/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.verifier.checksum.ChecksumValidator;
import com.facebook.presto.verifier.framework.DataVerification;
import com.facebook.presto.verifier.framework.PrestoAction;
import com.facebook.presto.verifier.framework.QueryRewriter;
import com.facebook.presto.verifier.framework.QueryType;
import com.facebook.presto.verifier.framework.SourceQuery;
import com.facebook.presto.verifier.framework.Verification;
import com.facebook.presto.verifier.framework.VerifierConfig;
import com.facebook.presto.verifier.framework.VerifierUtil;
import com.facebook.presto.verifier.resolver.FailureResolver;
import java.util.List;
import java.util.Objects;
import javax.inject.Inject;

public class VerificationFactory {
    private final SqlParser sqlParser;
    private final PrestoAction prestoAction;
    private final QueryRewriter queryRewriter;
    private final ChecksumValidator checksumValidator;
    private final List<FailureResolver> failureResolvers;
    private final VerifierConfig config;

    @Inject
    public VerificationFactory(SqlParser sqlParser, PrestoAction prestoAction, QueryRewriter queryRewriter, ChecksumValidator checksumValidator, List<FailureResolver> failureResolvers, VerifierConfig config) {
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.prestoAction = Objects.requireNonNull(prestoAction, "prestoAction is null");
        this.queryRewriter = Objects.requireNonNull(queryRewriter, "queryRewriter is null");
        this.checksumValidator = Objects.requireNonNull(checksumValidator, "checksumValidator is null");
        this.failureResolvers = Objects.requireNonNull(failureResolvers, "failureResolvers is null");
        this.config = Objects.requireNonNull(config, "config is null");
    }

    public Verification get(SourceQuery sourceQuery) {
        QueryType queryType = QueryType.of(this.sqlParser.createStatement(sourceQuery.getControlQuery(), VerifierUtil.PARSING_OPTIONS));
        switch (queryType.getCategory()) {
            case DATA_PRODUCING: {
                return new DataVerification(this.prestoAction, sourceQuery, this.queryRewriter, this.failureResolvers, this.config, this.checksumValidator);
            }
        }
        throw new IllegalStateException(String.format("Unsupported query type: %s", new Object[]{queryType}));
    }
}

