/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.jdbc.QueryStats;
import com.facebook.presto.verifier.event.FailureInfo;
import com.facebook.presto.verifier.framework.QueryException;
import com.facebook.presto.verifier.framework.QueryOrigin;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import java.util.EnumMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class VerificationContext {
    private Map<QueryOrigin.TargetCluster, Set<QueryException>> failures = new EnumMap<QueryOrigin.TargetCluster, Set<QueryException>>(QueryOrigin.TargetCluster.class);

    public VerificationContext() {
        this.failures.put(QueryOrigin.TargetCluster.CONTROL, new LinkedHashSet());
        this.failures.put(QueryOrigin.TargetCluster.TEST, new LinkedHashSet());
    }

    public void recordFailure(QueryException exception) {
        this.failures.get((Object)exception.getQueryOrigin().getCluster()).add(exception);
    }

    public List<FailureInfo> getAllFailures(QueryOrigin.TargetCluster cluster) {
        return (List)this.failures.get((Object)cluster).stream().map(exception -> new FailureInfo(exception.getQueryOrigin().getStage(), exception.getErrorCode(), exception.getQueryStats().map(QueryStats::getQueryId), Throwables.getStackTraceAsString((Throwable)exception))).collect(ImmutableList.toImmutableList());
    }
}

