/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.CreateTable;
import com.facebook.presto.sql.tree.CreateTableAsSelect;
import com.facebook.presto.sql.tree.DropTable;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.Insert;
import com.facebook.presto.sql.tree.LikeClause;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.QueryBody;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.verifier.framework.PrestoAction;
import com.facebook.presto.verifier.framework.QueryBundle;
import com.facebook.presto.verifier.framework.QueryConfiguration;
import com.facebook.presto.verifier.framework.QueryOrigin;
import com.facebook.presto.verifier.framework.QueryType;
import com.facebook.presto.verifier.framework.VerificationContext;
import com.facebook.presto.verifier.framework.VerifierConfig;
import com.facebook.presto.verifier.framework.VerifierUtil;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.UUID;
import javax.inject.Inject;
import org.intellij.lang.annotations.Language;

public class QueryRewriter {
    private final SqlParser sqlParser;
    private final PrestoAction prestoAction;
    private final Map<QueryOrigin.TargetCluster, QualifiedName> prefixes;

    @Inject
    public QueryRewriter(SqlParser sqlParser, PrestoAction prestoAction, VerifierConfig config) {
        this.sqlParser = Objects.requireNonNull(sqlParser, "sqlParser is null");
        this.prestoAction = Objects.requireNonNull(prestoAction, "prestoAction is null");
        this.prefixes = ImmutableMap.of((Object)((Object)QueryOrigin.TargetCluster.CONTROL), (Object)config.getControlTablePrefix(), (Object)((Object)QueryOrigin.TargetCluster.TEST), (Object)config.getTestTablePrefix());
    }

    public QueryBundle rewriteQuery(@Language(value="SQL") String query, QueryOrigin.TargetCluster cluster, QueryConfiguration controlConfiguration, VerificationContext context) {
        Statement statement = this.sqlParser.createStatement(query, VerifierUtil.PARSING_OPTIONS);
        if (QueryType.of(statement).getCategory() != QueryType.Category.DATA_PRODUCING) {
            return new QueryBundle(Optional.empty(), (List<Statement>)ImmutableList.of(), statement, (List<Statement>)ImmutableList.of());
        }
        QualifiedName prefix = this.prefixes.get((Object)cluster);
        if (statement instanceof CreateTableAsSelect) {
            CreateTableAsSelect createTableAsSelect = (CreateTableAsSelect)statement;
            QualifiedName temporaryTableName = this.generateTemporaryTableName(Optional.of(createTableAsSelect.getName()), prefix);
            return new QueryBundle(Optional.of(temporaryTableName), (List<Statement>)ImmutableList.of(), (Statement)new CreateTableAsSelect(temporaryTableName, createTableAsSelect.getQuery(), createTableAsSelect.isNotExists(), createTableAsSelect.getProperties(), createTableAsSelect.isWithData(), createTableAsSelect.getColumnAliases(), createTableAsSelect.getComment()), (List<Statement>)ImmutableList.of((Object)new DropTable(temporaryTableName, true)));
        }
        if (statement instanceof Insert) {
            Insert insert = (Insert)statement;
            QualifiedName originalTableName = insert.getTarget();
            QualifiedName temporaryTableName = this.generateTemporaryTableName(Optional.of(originalTableName), prefix);
            return new QueryBundle(Optional.of(temporaryTableName), (List<Statement>)ImmutableList.of((Object)new CreateTable(temporaryTableName, (List)ImmutableList.of((Object)new LikeClause(originalTableName, Optional.of(LikeClause.PropertiesOption.INCLUDING))), false, (List)ImmutableList.of(), Optional.empty())), (Statement)new Insert(temporaryTableName, insert.getColumns(), insert.getQuery()), (List<Statement>)ImmutableList.of((Object)new DropTable(temporaryTableName, true)));
        }
        if (statement instanceof Query) {
            QualifiedName temporaryTableName = this.generateTemporaryTableName(Optional.empty(), prefix);
            return new QueryBundle(Optional.of(temporaryTableName), (List<Statement>)ImmutableList.of(), (Statement)new CreateTableAsSelect(temporaryTableName, (Query)statement, false, (List)ImmutableList.of(), true, Optional.of(this.generateStorageColumnAliases((Query)statement, controlConfiguration, context)), Optional.empty()), (List<Statement>)ImmutableList.of((Object)new DropTable(temporaryTableName, true)));
        }
        throw new IllegalStateException(String.format("Unsupported query type: %s", statement.getClass()));
    }

    private QualifiedName generateTemporaryTableName(Optional<QualifiedName> originalName, QualifiedName prefix) {
        ArrayList parts = new ArrayList();
        int originalSize = originalName.map(QualifiedName::getOriginalParts).map(List::size).orElse(0);
        int prefixSize = prefix.getOriginalParts().size();
        if (originalName.isPresent() && originalSize > prefixSize) {
            parts.addAll(originalName.get().getOriginalParts().subList(0, originalSize - prefixSize));
        }
        parts.addAll(prefix.getOriginalParts());
        parts.set(parts.size() - 1, prefix.getSuffix() + "_" + UUID.randomUUID().toString().replace("-", ""));
        return QualifiedName.of(parts);
    }

    private List<Identifier> generateStorageColumnAliases(Query query, QueryConfiguration configuration, VerificationContext context) {
        ImmutableList.Builder aliases = ImmutableList.builder();
        HashSet<String> usedAliases = new HashSet<String>();
        for (String columnName : this.getColumnNames(query, configuration, context)) {
            String alias = columnName = QueryRewriter.sanitizeColumnName(columnName);
            int postfix = 1;
            while (usedAliases.contains(alias)) {
                alias = String.format("%s__%s", columnName, postfix);
                ++postfix;
            }
            aliases.add((Object)new Identifier(alias, true));
            usedAliases.add(alias);
        }
        return aliases.build();
    }

    private List<String> getColumnNames(Query query, QueryConfiguration configuration, VerificationContext context) {
        Query zeroRowQuery;
        if (query.getQueryBody() instanceof QuerySpecification) {
            QuerySpecification querySpecification = (QuerySpecification)query.getQueryBody();
            zeroRowQuery = new Query(query.getWith(), (QueryBody)new QuerySpecification(querySpecification.getSelect(), querySpecification.getFrom(), querySpecification.getWhere(), querySpecification.getGroupBy(), querySpecification.getHaving(), querySpecification.getOrderBy(), Optional.of("0")), Optional.empty(), Optional.empty());
        } else {
            zeroRowQuery = new Query(query.getWith(), query.getQueryBody(), Optional.empty(), Optional.of("0"));
        }
        return this.prestoAction.execute((Statement)zeroRowQuery, configuration, QueryOrigin.forRewrite(), context, PrestoAction.ResultSetConverter.DEFAULT).getColumnNames();
    }

    private static String sanitizeColumnName(String columnName) {
        return columnName.replaceAll("[^a-zA-Z0-9_]", "_").toLowerCase(Locale.ENGLISH);
    }
}

