/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import java.util.Objects;

public class QueryOrigin {
    private final TargetCluster cluster;
    private final QueryStage stage;

    private QueryOrigin(TargetCluster cluster, QueryStage stage) {
        this.cluster = Objects.requireNonNull(cluster, "cluster is null");
        this.stage = Objects.requireNonNull(stage, "stage is null");
    }

    public static QueryOrigin forSetup(TargetCluster group) {
        return new QueryOrigin(group, QueryStage.SETUP);
    }

    public static QueryOrigin forMain(TargetCluster group) {
        return new QueryOrigin(group, QueryStage.MAIN);
    }

    public static QueryOrigin forTeardown(TargetCluster group) {
        return new QueryOrigin(group, QueryStage.TEARDOWN);
    }

    public static QueryOrigin forRewrite() {
        return new QueryOrigin(TargetCluster.CONTROL, QueryStage.REWRITE);
    }

    public static QueryOrigin forDescribe() {
        return new QueryOrigin(TargetCluster.CONTROL, QueryStage.DESCRIBE);
    }

    public static QueryOrigin forChecksum() {
        return new QueryOrigin(TargetCluster.CONTROL, QueryStage.CHECKSUM);
    }

    public TargetCluster getCluster() {
        return this.cluster;
    }

    public QueryStage getStage() {
        return this.stage;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        QueryOrigin o = (QueryOrigin)obj;
        return Objects.equals((Object)this.cluster, (Object)o.cluster) && Objects.equals((Object)this.stage, (Object)o.stage);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.cluster, this.stage});
    }

    public static enum QueryStage {
        SETUP,
        MAIN,
        TEARDOWN,
        REWRITE,
        DESCRIBE,
        CHECKSUM;

    }

    public static enum TargetCluster {
        CONTROL,
        TEST;

    }
}

