/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.jdbc.QueryStats;
import com.facebook.presto.spi.ErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.verifier.framework.QueryOrigin;
import com.google.common.base.Function;
import java.util.Objects;
import java.util.Optional;

public class QueryException
extends RuntimeException {
    private final Type type;
    private final Optional<ErrorCodeSupplier> prestoErrorCode;
    private final boolean retryable;
    private final Optional<QueryStats> queryStats;
    private final QueryOrigin queryOrigin;

    private QueryException(Throwable cause, Type type, Optional<ErrorCodeSupplier> prestoErrorCode, boolean retryable, Optional<QueryStats> queryStats, QueryOrigin queryOrigin) {
        super(cause);
        this.type = Objects.requireNonNull(type, "type is null");
        this.prestoErrorCode = Objects.requireNonNull(prestoErrorCode, "errorCode is null");
        this.retryable = retryable;
        this.queryStats = Objects.requireNonNull(queryStats, "queryStats is null");
        this.queryOrigin = Objects.requireNonNull(queryOrigin, "queryOrigin is null");
    }

    public static QueryException forClusterConnection(Throwable cause, QueryOrigin queryOrigin) {
        return new QueryException(cause, Type.CLUSTER_CONNECTION, Optional.empty(), true, Optional.empty(), queryOrigin);
    }

    public static QueryException forPresto(Throwable cause, Optional<ErrorCodeSupplier> prestoErrorCode, boolean retryable, Optional<QueryStats> queryStats, QueryOrigin queryOrigin) {
        return new QueryException(cause, Type.PRESTO, prestoErrorCode, retryable, queryStats, queryOrigin);
    }

    public Type getType() {
        return this.type;
    }

    public Optional<ErrorCodeSupplier> getPrestoErrorCode() {
        return this.prestoErrorCode;
    }

    public boolean isRetryable() {
        return this.retryable;
    }

    public Optional<QueryStats> getQueryStats() {
        return this.queryStats;
    }

    public QueryOrigin getQueryOrigin() {
        return this.queryOrigin;
    }

    public String getErrorCode() {
        return String.format("%s(%s)", this.type.name(), this.type.descriptionGenerator.apply((Object)this));
    }

    public static enum Type {
        CLUSTER_CONNECTION((Function<QueryException, String>)((Function)qe -> {
            Objects.requireNonNull(qe, "queryException is null");
            Objects.requireNonNull(qe.getCause(), "cause is null");
            return qe.getCause().getClass().getSimpleName();
        })),
        PRESTO((Function<QueryException, String>)((Function)qe -> {
            Objects.requireNonNull(qe, "queryException is null");
            return ((QueryException)qe).prestoErrorCode.map(ErrorCodeSupplier::toErrorCode).map(ErrorCode::getName).orElse("UNKNOWN");
        }));

        private final Function<QueryException, String> descriptionGenerator;

        private Type(Function<QueryException, String> descriptionGenerator) {
            this.descriptionGenerator = Objects.requireNonNull(descriptionGenerator, "descriptionGenerator is null");
        }
    }
}

