/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.google.common.collect.ImmutableMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import org.jdbi.v3.core.mapper.reflect.ColumnName;
import org.jdbi.v3.core.mapper.reflect.JdbiConstructor;

public class QueryConfiguration {
    private final String catalog;
    private final String schema;
    private final String username;
    private final Optional<String> password;
    private final Map<String, String> sessionProperties;

    @JdbiConstructor
    public QueryConfiguration(@ColumnName(value="catalog") String catalog, @ColumnName(value="schema") String schema, @ColumnName(value="username") String username, @ColumnName(value="password") Optional<String> password, @ColumnName(value="session_properties") Optional<Map<String, String>> sessionProperties) {
        this(catalog, schema, username, password, sessionProperties.orElse((Map<String, String>)ImmutableMap.of()));
    }

    public QueryConfiguration(String catalog, String schema, String username, Optional<String> password, Map<String, String> sessionProperties) {
        this.catalog = Objects.requireNonNull(catalog, "catalog is null");
        this.schema = Objects.requireNonNull(schema, "schema is null");
        this.username = Objects.requireNonNull(username, "username is null");
        this.password = Objects.requireNonNull(password, "password is null");
        this.sessionProperties = ImmutableMap.copyOf(sessionProperties);
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getUsername() {
        return this.username;
    }

    public Optional<String> getPassword() {
        return this.password;
    }

    public Map<String, String> getSessionProperties() {
        return this.sessionProperties;
    }
}

