/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Statement;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;

public class QueryBundle {
    private final Optional<QualifiedName> tableName;
    private final List<Statement> setupQueries;
    private final Statement query;
    private final List<Statement> teardownQueries;

    public QueryBundle(Optional<QualifiedName> tableName, List<Statement> setupQueries, Statement query, List<Statement> teardownQueries) {
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        this.setupQueries = ImmutableList.copyOf(setupQueries);
        this.query = Objects.requireNonNull(query, "mainQueries is null");
        this.teardownQueries = ImmutableList.copyOf(teardownQueries);
    }

    public QualifiedName getTableName() {
        Preconditions.checkState((boolean)this.tableName.isPresent(), (Object)"tableName is missing");
        return this.tableName.get();
    }

    public List<Statement> getSetupQueries() {
        return this.setupQueries;
    }

    public Statement getQuery() {
        return this.query;
    }

    public List<Statement> getTeardownQueries() {
        return this.teardownQueries;
    }
}

