/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.connector.thrift.ThriftErrorCode;
import com.facebook.presto.hive.HiveErrorCode;
import com.facebook.presto.jdbc.QueryStats;
import com.facebook.presto.plugin.jdbc.JdbcErrorCode;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.verifier.framework.QueryException;
import com.facebook.presto.verifier.framework.QueryOrigin;
import com.facebook.presto.verifier.framework.SqlExceptionClassifier;
import com.google.common.base.Functions;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import java.io.EOFException;
import java.io.UncheckedIOException;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.sql.SQLException;
import java.util.Arrays;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.concurrent.TimeoutException;
import java.util.function.Function;

public class PrestoExceptionClassifier
implements SqlExceptionClassifier {
    private static final Set<ErrorCodeSupplier> DEFAULT_ERRORS = ImmutableSet.builder().addAll(Arrays.asList(StandardErrorCode.values())).addAll(Arrays.asList(HiveErrorCode.values())).addAll(Arrays.asList(JdbcErrorCode.values())).addAll(Arrays.asList(ThriftErrorCode.values())).build();
    private static final Set<ErrorCodeSupplier> DEFAULT_RETRYABLE_ERRORS = ImmutableSet.of((Object)StandardErrorCode.NO_NODES_AVAILABLE, (Object)StandardErrorCode.REMOTE_TASK_ERROR, (Object)StandardErrorCode.SERVER_SHUTTING_DOWN, (Object)StandardErrorCode.SERVER_STARTING_UP, (Object)StandardErrorCode.TOO_MANY_REQUESTS_FAILED, (Object)StandardErrorCode.PAGE_TRANSPORT_ERROR, (Object[])new ErrorCodeSupplier[]{StandardErrorCode.PAGE_TRANSPORT_TIMEOUT, StandardErrorCode.REMOTE_HOST_GONE, StandardErrorCode.ABANDONED_TASK, HiveErrorCode.HIVE_CURSOR_ERROR, HiveErrorCode.HIVE_FILE_NOT_FOUND, HiveErrorCode.HIVE_TOO_MANY_OPEN_PARTITIONS, HiveErrorCode.HIVE_WRITER_OPEN_ERROR, HiveErrorCode.HIVE_WRITER_CLOSE_ERROR, HiveErrorCode.HIVE_WRITER_DATA_ERROR, HiveErrorCode.HIVE_FILESYSTEM_ERROR, HiveErrorCode.HIVE_CANNOT_OPEN_SPLIT, HiveErrorCode.HIVE_METASTORE_ERROR, JdbcErrorCode.JDBC_ERROR, ThriftErrorCode.THRIFT_SERVICE_CONNECTION_ERROR});
    private final Map<Integer, ErrorCodeSupplier> errorByCode;
    private final Set<ErrorCodeSupplier> retryableErrors;

    public PrestoExceptionClassifier(Set<ErrorCodeSupplier> additionalErrors, Set<ErrorCodeSupplier> additionalRetryableErrors) {
        this.errorByCode = (Map)ImmutableSet.builder().addAll(DEFAULT_ERRORS).addAll(additionalErrors).build().stream().collect(ImmutableMap.toImmutableMap(errorCode -> errorCode.toErrorCode().getCode(), (Function)Functions.identity()));
        this.retryableErrors = ImmutableSet.builder().addAll(DEFAULT_RETRYABLE_ERRORS).addAll(additionalRetryableErrors).build();
    }

    @Override
    public QueryException createException(QueryOrigin queryOrigin, Optional<QueryStats> queryStats, SQLException cause) {
        Optional<ErrorCodeSupplier> errorCode;
        Optional<Throwable> clusterConnectionExceptionCause = PrestoExceptionClassifier.getClusterConnectionExceptionCause(cause);
        if (clusterConnectionExceptionCause.isPresent()) {
            return QueryException.forClusterConnection(clusterConnectionExceptionCause.get(), queryOrigin);
        }
        return QueryException.forPresto(cause, errorCode, (errorCode = Optional.ofNullable(this.errorByCode.get(cause.getErrorCode()))).isPresent() && this.retryableErrors.contains(errorCode.get()), queryStats, queryOrigin);
    }

    private static Optional<Throwable> getClusterConnectionExceptionCause(Throwable t) {
        while (t != null) {
            if (t instanceof SocketTimeoutException || t instanceof SocketException || t instanceof EOFException || t instanceof UncheckedIOException || t instanceof TimeoutException || t.getClass().equals(RuntimeException.class) && t.getMessage() != null && t.getMessage().contains("Error fetching next at")) {
                return Optional.of(t);
            }
            t = t.getCause();
        }
        return Optional.empty();
    }
}

