/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.jdbc.PrestoConnection;
import com.facebook.presto.jdbc.QueryStats;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.verifier.framework.QueryConfiguration;
import com.facebook.presto.verifier.framework.QueryException;
import com.facebook.presto.verifier.framework.QueryOrigin;
import com.facebook.presto.verifier.framework.QueryResult;
import com.facebook.presto.verifier.framework.SqlExceptionClassifier;
import com.facebook.presto.verifier.framework.VerificationContext;
import com.facebook.presto.verifier.framework.VerifierConfig;
import com.facebook.presto.verifier.retry.ForClusterConnection;
import com.facebook.presto.verifier.retry.ForPresto;
import com.facebook.presto.verifier.retry.RetryConfig;
import com.facebook.presto.verifier.retry.RetryDriver;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.units.Duration;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Consumer;
import javax.inject.Inject;

public class PrestoAction {
    private static final String QUERY_MAX_EXECUTION_TIME = "query_max_execution_time";
    private final SqlExceptionClassifier exceptionClassifier;
    private final Map<QueryOrigin.TargetCluster, String> clusterUrls;
    private final Duration controlTimeout;
    private final Duration testTimeout;
    private final Duration metadataTimeout;
    private final Duration checksumTimeout;
    private final RetryDriver networkRetry;
    private final RetryDriver prestoRetry;

    @Inject
    public PrestoAction(SqlExceptionClassifier exceptionClassifier, VerifierConfig config, @ForClusterConnection RetryConfig networkRetryConfig, @ForPresto RetryConfig prestoRetryConfig) {
        this.exceptionClassifier = Objects.requireNonNull(exceptionClassifier, "exceptionClassifier is null");
        this.clusterUrls = ImmutableMap.of((Object)((Object)QueryOrigin.TargetCluster.CONTROL), (Object)config.getControlJdbcUrl(), (Object)((Object)QueryOrigin.TargetCluster.TEST), (Object)config.getTestJdbcUrl());
        this.controlTimeout = Objects.requireNonNull(config.getControlTimeout(), "controlTimeout is null");
        this.testTimeout = Objects.requireNonNull(config.getTestTimeout(), "testTimeout is null");
        this.metadataTimeout = Objects.requireNonNull(config.getMetadataTimeout(), "metadataTimeout is null");
        this.checksumTimeout = Objects.requireNonNull(config.getChecksumTimeout(), "checksumTimeout is null");
        this.networkRetry = new RetryDriver(networkRetryConfig, queryException -> queryException.getType() == QueryException.Type.CLUSTER_CONNECTION);
        this.prestoRetry = new RetryDriver(prestoRetryConfig, queryException -> queryException.getType() == QueryException.Type.PRESTO && queryException.isRetryable());
    }

    public QueryStats execute(Statement statement, QueryConfiguration configuration, QueryOrigin queryOrigin, VerificationContext context) {
        return this.execute(statement, configuration, queryOrigin, context, Optional.empty()).getQueryStats();
    }

    public <R> QueryResult<R> execute(Statement statement, QueryConfiguration configuration, QueryOrigin queryOrigin, VerificationContext context, ResultSetConverter<R> converter) {
        return this.execute(statement, configuration, queryOrigin, context, Optional.of(converter));
    }

    private <R> QueryResult<R> execute(Statement statement, QueryConfiguration configuration, QueryOrigin queryOrigin, VerificationContext context, Optional<ResultSetConverter<R>> converter) {
        return this.prestoRetry.run("presto", context, () -> this.networkRetry.run("presto-cluster-connection", context, () -> this.executeOnce(statement, configuration, queryOrigin, converter)));
    }

    /*
     * Exception decompiling
     */
    private <R> QueryResult<R> executeOnce(Statement statement, QueryConfiguration configuration, QueryOrigin queryOrigin, Optional<ResultSetConverter<R>> converter) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Started 3 blocks at once
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.getStartingBlocks(Op04StructuredStatement.java:412)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:487)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void consumeResultSet(ResultSet resultSet) throws SQLException {
        while (resultSet.next()) {
        }
    }

    public PrestoConnection getConnection(QueryConfiguration configuration, QueryOrigin queryOrigin) throws SQLException {
        PrestoConnection connection = DriverManager.getConnection(this.clusterUrls.get((Object)queryOrigin.getCluster()), configuration.getUsername(), configuration.getPassword().orElse(null)).unwrap(PrestoConnection.class);
        try {
            connection.setClientInfo("ApplicationName", "verifier-test");
            connection.setCatalog(configuration.getCatalog());
            connection.setSchema(configuration.getSchema());
        }
        catch (SQLClientInfoException sQLClientInfoException) {
            // empty catch block
        }
        ImmutableMap sessionProperties = ImmutableMap.builder().putAll(configuration.getSessionProperties()).put((Object)QUERY_MAX_EXECUTION_TIME, (Object)this.getTimeout(queryOrigin).toString()).build();
        for (Map.Entry entry : sessionProperties.entrySet()) {
            connection.setSessionProperty((String)entry.getKey(), (String)entry.getValue());
        }
        return connection;
    }

    private Duration getTimeout(QueryOrigin queryOrigin) {
        QueryOrigin.TargetCluster cluster = queryOrigin.getCluster();
        Preconditions.checkState((cluster == QueryOrigin.TargetCluster.CONTROL || cluster == QueryOrigin.TargetCluster.TEST ? 1 : 0) != 0, (String)"Invalid TargetCluster: %s", (Object)((Object)cluster));
        switch (queryOrigin.getStage()) {
            case SETUP: 
            case MAIN: 
            case TEARDOWN: {
                return cluster == QueryOrigin.TargetCluster.CONTROL ? this.controlTimeout : this.testTimeout;
            }
            case REWRITE: 
            case DESCRIBE: {
                return this.metadataTimeout;
            }
            case CHECKSUM: {
                return this.checksumTimeout;
            }
        }
        throw new IllegalArgumentException(String.format("Invalid QueryStage: %s", new Object[]{queryOrigin.getStage()}));
    }

    static class ProgressMonitor
    implements Consumer<QueryStats> {
        private Optional<QueryStats> queryStats = Optional.empty();

        ProgressMonitor() {
        }

        @Override
        public synchronized void accept(QueryStats queryStats) {
            this.queryStats = Optional.of(Objects.requireNonNull(queryStats, "queryStats is null"));
        }

        public synchronized Optional<QueryStats> getLastQueryStats() {
            return this.queryStats;
        }
    }

    @FunctionalInterface
    static interface ResultSetConverter<R> {
        public static final ResultSetConverter<List<Object>> DEFAULT = resultSet -> {
            ImmutableList.Builder row = ImmutableList.builder();
            for (int i = 0; i < resultSet.getMetaData().getColumnCount(); ++i) {
                row.add(resultSet.getObject(i));
            }
            return row.build();
        };

        public R apply(ResultSet var1) throws SQLException;
    }
}

