/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.verifier.framework.ForwardingDriver;
import com.google.common.collect.ImmutableList;
import java.io.File;
import java.io.IOException;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.sql.Driver;
import java.sql.DriverManager;
import java.sql.SQLException;
import java.util.List;
import java.util.Optional;

public class JdbcDriverUtil {
    private JdbcDriverUtil() {
    }

    public static void initializeDrivers(Optional<String> additionalJdbcDriverPath, Optional<String> controlJdbcDriverClass, Optional<String> testJdbcDriverClass) {
        if (additionalJdbcDriverPath.isPresent()) {
            List<URL> urlList = JdbcDriverUtil.getUrls(additionalJdbcDriverPath.get());
            URL[] urls = new URL[urlList.size()];
            urlList.toArray(urls);
            controlJdbcDriverClass.ifPresent(driver -> JdbcDriverUtil.loadJdbcDriver(urls, driver));
            testJdbcDriverClass.ifPresent(driver -> JdbcDriverUtil.loadJdbcDriver(urls, driver));
        }
    }

    private static void loadJdbcDriver(URL[] urls, String jdbcClassName) {
        try (URLClassLoader classLoader = new URLClassLoader(urls);){
            Driver driver = (Driver)Class.forName(jdbcClassName, true, classLoader).getConstructor(new Class[0]).newInstance(new Object[0]);
            DriverManager.registerDriver(new ForwardingDriver(driver));
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        catch (ReflectiveOperationException | SQLException e) {
            throw new RuntimeException(e);
        }
    }

    private static List<URL> getUrls(String path) {
        try {
            ImmutableList.Builder urlList = ImmutableList.builder();
            File driverPath = new File(path);
            if (!driverPath.isDirectory()) {
                return urlList.add((Object)Paths.get(path, new String[0]).toUri().toURL()).build();
            }
            File[] files = driverPath.listFiles((dir, name) -> name.endsWith(".jar"));
            if (files == null) {
                return urlList.build();
            }
            for (File file : files) {
                if (file.isDirectory()) continue;
                urlList.add((Object)Paths.get(file.getAbsolutePath(), new String[0]).toUri().toURL());
            }
            return urlList.build();
        }
        catch (MalformedURLException e) {
            throw new RuntimeException(e);
        }
    }
}

