/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.jdbc.QueryStats;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.Query;
import com.facebook.presto.sql.tree.ShowColumns;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.verifier.checksum.ChecksumResult;
import com.facebook.presto.verifier.checksum.ChecksumValidator;
import com.facebook.presto.verifier.checksum.ColumnMatchResult;
import com.facebook.presto.verifier.framework.AbstractVerification;
import com.facebook.presto.verifier.framework.Column;
import com.facebook.presto.verifier.framework.MatchResult;
import com.facebook.presto.verifier.framework.PrestoAction;
import com.facebook.presto.verifier.framework.QueryBundle;
import com.facebook.presto.verifier.framework.QueryOrigin;
import com.facebook.presto.verifier.framework.QueryResult;
import com.facebook.presto.verifier.framework.QueryRewriter;
import com.facebook.presto.verifier.framework.SourceQuery;
import com.facebook.presto.verifier.framework.VerificationResult;
import com.facebook.presto.verifier.framework.VerifierConfig;
import com.facebook.presto.verifier.resolver.FailureResolver;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.OptionalLong;

public class DataVerification
extends AbstractVerification {
    private final ChecksumValidator checksumValidator;

    public DataVerification(PrestoAction prestoAction, SourceQuery sourceQuery, QueryRewriter queryRewriter, List<FailureResolver> failureResolvers, VerifierConfig config, ChecksumValidator checksumValidator) {
        super(prestoAction, sourceQuery, queryRewriter, failureResolvers, config);
        this.checksumValidator = Objects.requireNonNull(checksumValidator, "checksumValidator is null");
    }

    @Override
    public VerificationResult verify(QueryBundle control, QueryBundle test) {
        this.setQueryStats(this.setupAndRun(control, QueryOrigin.TargetCluster.CONTROL), QueryOrigin.TargetCluster.CONTROL);
        this.setQueryStats(this.setupAndRun(test, QueryOrigin.TargetCluster.TEST), QueryOrigin.TargetCluster.TEST);
        List<Column> controlColumns = this.getColumns(control.getTableName(), QueryOrigin.TargetCluster.CONTROL);
        List<Column> testColumns = this.getColumns(test.getTableName(), QueryOrigin.TargetCluster.TEST);
        ChecksumQueryAndResult controlChecksum = this.computeChecksum(control, controlColumns, QueryOrigin.TargetCluster.CONTROL);
        ChecksumQueryAndResult testChecksum = this.computeChecksum(test, testColumns, QueryOrigin.TargetCluster.TEST);
        return new VerificationResult(controlChecksum.getQueryId(), testChecksum.getQueryId(), DataVerification.formatSql((Statement)controlChecksum.getQuery()), DataVerification.formatSql((Statement)testChecksum.getQuery()), this.match(controlColumns, testColumns, controlChecksum.getResult(), testChecksum.getResult()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected Optional<Boolean> isDeterministic(QueryBundle control, ChecksumResult firstChecksum) {
        Optional<Boolean> optional;
        QueryBundle thirdRun;
        block16: {
            QueryBundle secondRun;
            block14: {
                Optional<Boolean> optional2;
                block15: {
                    List<Column> columns;
                    block12: {
                        Optional<Boolean> optional3;
                        block13: {
                            columns = this.getColumns(control.getTableName(), QueryOrigin.TargetCluster.CONTROL);
                            secondRun = null;
                            thirdRun = null;
                            secondRun = this.getQueryRewriter().rewriteQuery(this.getSourceQuery().getControlQuery(), QueryOrigin.TargetCluster.CONTROL, this.getConfiguration(QueryOrigin.TargetCluster.CONTROL), this.getVerificationContext());
                            this.setupAndRun(secondRun, QueryOrigin.TargetCluster.CONTROL);
                            if (this.match(columns, columns, firstChecksum, this.computeChecksum(secondRun, columns, QueryOrigin.TargetCluster.CONTROL).getResult()).isMatched()) break block12;
                            optional3 = Optional.of(false);
                            if (secondRun == null) break block13;
                            this.teardownSafely(secondRun, QueryOrigin.TargetCluster.CONTROL);
                        }
                        if (thirdRun != null) {
                            this.teardownSafely(thirdRun, QueryOrigin.TargetCluster.CONTROL);
                        }
                        return optional3;
                    }
                    thirdRun = this.getQueryRewriter().rewriteQuery(this.getSourceQuery().getControlQuery(), QueryOrigin.TargetCluster.CONTROL, this.getConfiguration(QueryOrigin.TargetCluster.CONTROL), this.getVerificationContext());
                    this.setupAndRun(thirdRun, QueryOrigin.TargetCluster.CONTROL);
                    if (this.match(columns, columns, firstChecksum, this.computeChecksum(thirdRun, columns, QueryOrigin.TargetCluster.CONTROL).getResult()).isMatched()) break block14;
                    optional2 = Optional.of(false);
                    if (secondRun == null) break block15;
                    this.teardownSafely(secondRun, QueryOrigin.TargetCluster.CONTROL);
                }
                if (thirdRun != null) {
                    this.teardownSafely(thirdRun, QueryOrigin.TargetCluster.CONTROL);
                }
                return optional2;
            }
            try {
                optional = Optional.of(true);
                if (secondRun == null) break block16;
            }
            catch (Throwable t) {
                try {
                    Optional<Boolean> optional4 = Optional.empty();
                    return optional4;
                }
                catch (Throwable throwable) {
                    throw throwable;
                }
                finally {
                    if (secondRun != null) {
                        this.teardownSafely(secondRun, QueryOrigin.TargetCluster.CONTROL);
                    }
                    if (thirdRun != null) {
                        this.teardownSafely(thirdRun, QueryOrigin.TargetCluster.CONTROL);
                    }
                }
            }
            this.teardownSafely(secondRun, QueryOrigin.TargetCluster.CONTROL);
        }
        if (thirdRun != null) {
            this.teardownSafely(thirdRun, QueryOrigin.TargetCluster.CONTROL);
        }
        return optional;
    }

    private QueryStats setupAndRun(QueryBundle control, QueryOrigin.TargetCluster cluster) {
        this.setup(control, cluster);
        return this.getPrestoAction().execute(control.getQuery(), this.getConfiguration(cluster), QueryOrigin.forMain(cluster), this.getVerificationContext());
    }

    private MatchResult match(List<Column> controlColumns, List<Column> testColumns, ChecksumResult controlChecksum, ChecksumResult testChecksum) {
        MatchResult.MatchType matchType;
        Object mismatchedColumns;
        if (!controlColumns.equals(testColumns)) {
            return new MatchResult(MatchResult.MatchType.SCHEMA_MISMATCH, Optional.empty(), OptionalLong.empty(), OptionalLong.empty(), (Map<Column, ColumnMatchResult>)ImmutableMap.of());
        }
        OptionalLong controlRowCount = OptionalLong.of(controlChecksum.getRowCount());
        OptionalLong testRowCount = OptionalLong.of(testChecksum.getRowCount());
        if (controlChecksum.getRowCount() != testChecksum.getRowCount()) {
            mismatchedColumns = ImmutableMap.of();
            matchType = MatchResult.MatchType.ROW_COUNT_MISMATCH;
        } else {
            mismatchedColumns = this.checksumValidator.getMismatchedColumns(controlColumns, controlChecksum, testChecksum);
            matchType = mismatchedColumns.isEmpty() ? MatchResult.MatchType.MATCH : MatchResult.MatchType.COLUMN_MISMATCH;
        }
        return new MatchResult(matchType, Optional.of(controlChecksum), controlRowCount, testRowCount, (Map<Column, ColumnMatchResult>)mismatchedColumns);
    }

    private List<Column> getColumns(QualifiedName tableName, QueryOrigin.TargetCluster cluster) {
        return this.getPrestoAction().execute((Statement)new ShowColumns(tableName), this.getConfiguration(cluster), QueryOrigin.forDescribe(), this.getVerificationContext(), Column::fromResultSet).getResults();
    }

    private ChecksumQueryAndResult computeChecksum(QueryBundle bundle, List<Column> columns, QueryOrigin.TargetCluster cluster) {
        Query checksumQuery = this.checksumValidator.generateChecksumQuery(bundle.getTableName(), columns);
        QueryResult<ChecksumResult> queryResult = this.getPrestoAction().execute((Statement)checksumQuery, this.getConfiguration(cluster), QueryOrigin.forChecksum(), this.getVerificationContext(), ChecksumResult::fromResultSet);
        return new ChecksumQueryAndResult(queryResult.getQueryStats().getQueryId(), checksumQuery, (ChecksumResult)Iterables.getOnlyElement(queryResult.getResults()));
    }

    private class ChecksumQueryAndResult {
        private final String queryId;
        private final Query query;
        private final ChecksumResult result;

        public ChecksumQueryAndResult(String queryId, Query query, ChecksumResult result) {
            this.queryId = Objects.requireNonNull(queryId, "queryId is null");
            this.query = Objects.requireNonNull(query, "query is null");
            this.result = Objects.requireNonNull(result, "result is null");
        }

        public String getQueryId() {
            return this.queryId;
        }

        public Query getQuery() {
            return this.query;
        }

        public ChecksumResult getResult() {
            return this.result;
        }
    }
}

