/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.block.BlockEncodingManager;
import com.facebook.presto.metadata.FunctionManager;
import com.facebook.presto.spi.block.BlockEncoding;
import com.facebook.presto.spi.block.BlockEncodingSerde;
import com.facebook.presto.spi.type.ArrayType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.RealType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.TypeManager;
import com.facebook.presto.spi.type.TypeSignature;
import com.facebook.presto.sql.analyzer.FeaturesConfig;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.type.TypeRegistry;
import com.facebook.presto.verifier.framework.VerifierUtil;
import com.google.common.annotations.VisibleForTesting;
import com.google.common.collect.ImmutableSet;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.Objects;
import java.util.Set;

public class Column {
    private static final Set<Type> FLOATING_POINT_TYPES = ImmutableSet.of((Object)DoubleType.DOUBLE, (Object)RealType.REAL);
    private static final TypeRegistry typeRegistry = new TypeRegistry();
    private final String name;
    private final Category category;
    private final Type type;

    @VisibleForTesting
    public Column(String name, Category category, Type type) {
        this.name = Objects.requireNonNull(name, "name is null");
        this.category = Objects.requireNonNull(category, "kind is null");
        this.type = Objects.requireNonNull(type, "type is null");
    }

    public String getName() {
        return this.name;
    }

    public Identifier getIdentifier() {
        return VerifierUtil.delimitedIdentifier(this.name);
    }

    public Category getCategory() {
        return this.category;
    }

    public Type getType() {
        return this.type;
    }

    public static Column fromResultSet(ResultSet resultSet) throws SQLException {
        Type type = typeRegistry.getType(TypeSignature.parseTypeSignature((String)resultSet.getString("Type")));
        Category category = FLOATING_POINT_TYPES.contains(type) ? Category.FLOATING_POINT : (type instanceof ArrayType && ((ArrayType)type).getElementType().isOrderable() ? Category.ORDERABLE_ARRAY : Category.SIMPLE);
        return new Column(resultSet.getString("Column"), category, type);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Column o = (Column)obj;
        return Objects.equals(this.name, o.name) && Objects.equals((Object)this.category, (Object)o.category) && Objects.equals(this.type, o.type);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.name, this.category, this.type});
    }

    static {
        new FunctionManager((TypeManager)typeRegistry, (BlockEncodingSerde)new BlockEncodingManager((TypeManager)typeRegistry, new BlockEncoding[0]), new FeaturesConfig());
    }

    public static enum Category {
        SIMPLE,
        FLOATING_POINT,
        ORDERABLE_ARRAY;

    }
}

