/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.framework;

import com.facebook.presto.jdbc.QueryStats;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.sql.SqlFormatter;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.verifier.checksum.ChecksumResult;
import com.facebook.presto.verifier.event.FailureInfo;
import com.facebook.presto.verifier.event.QueryInfo;
import com.facebook.presto.verifier.event.VerifierQueryEvent;
import com.facebook.presto.verifier.framework.MatchResult;
import com.facebook.presto.verifier.framework.PrestoAction;
import com.facebook.presto.verifier.framework.QueryBundle;
import com.facebook.presto.verifier.framework.QueryConfiguration;
import com.facebook.presto.verifier.framework.QueryException;
import com.facebook.presto.verifier.framework.QueryOrigin;
import com.facebook.presto.verifier.framework.QueryRewriter;
import com.facebook.presto.verifier.framework.SourceQuery;
import com.facebook.presto.verifier.framework.Verification;
import com.facebook.presto.verifier.framework.VerificationContext;
import com.facebook.presto.verifier.framework.VerificationResult;
import com.facebook.presto.verifier.framework.VerifierConfig;
import com.facebook.presto.verifier.resolver.FailureResolver;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import io.airlift.log.Logger;
import io.airlift.units.Duration;
import java.util.EnumMap;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.TimeUnit;

public abstract class AbstractVerification
implements Verification {
    private static final Logger log = Logger.get(AbstractVerification.class);
    private final PrestoAction prestoAction;
    private final SourceQuery sourceQuery;
    private final QueryRewriter queryRewriter;
    private final List<FailureResolver> failureResolvers;
    private final String testId;
    private final boolean runTearDownOnResultMismatch;
    private final boolean failureResolverEnabled;
    private final VerificationContext verificationContext = new VerificationContext();
    private Map<QueryOrigin.TargetCluster, QueryStats> queryStats = new EnumMap<QueryOrigin.TargetCluster, QueryStats>(QueryOrigin.TargetCluster.class);

    public AbstractVerification(PrestoAction prestoAction, SourceQuery sourceQuery, QueryRewriter queryRewriter, List<FailureResolver> failureResolvers, VerifierConfig config) {
        this.prestoAction = Objects.requireNonNull(prestoAction, "prestoAction is null");
        this.sourceQuery = Objects.requireNonNull(sourceQuery, "sourceQuery is null");
        this.queryRewriter = Objects.requireNonNull(queryRewriter, "queryRewriter is null");
        this.failureResolvers = Objects.requireNonNull(failureResolvers, "failureResolvers is null");
        this.testId = Objects.requireNonNull(config.getTestId(), "testId is null");
        this.runTearDownOnResultMismatch = config.isRunTearDownOnResultMismatch();
        this.failureResolverEnabled = config.isFailureResolverEnabled();
    }

    protected abstract VerificationResult verify(QueryBundle var1, QueryBundle var2);

    protected abstract Optional<Boolean> isDeterministic(QueryBundle var1, ChecksumResult var2);

    protected VerificationContext getVerificationContext() {
        return this.verificationContext;
    }

    protected void setQueryStats(QueryStats queryStats, QueryOrigin.TargetCluster cluster) {
        Preconditions.checkState((!this.queryStats.containsKey((Object)cluster) ? 1 : 0) != 0, (String)"%sQueryStats has already been set", (Object)cluster.name().toLowerCase(Locale.ENGLISH));
        this.queryStats.put(cluster, queryStats);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    @Override
    public Optional<VerifierQueryEvent> run() {
        Optional<VerifierQueryEvent> optional;
        block16: {
            QueryBundle test;
            block17: {
                boolean resultMismatched = false;
                QueryBundle control = null;
                test = null;
                VerificationResult verificationResult = null;
                Optional<Boolean> deterministic = Optional.empty();
                try {
                    control = this.queryRewriter.rewriteQuery(this.sourceQuery.getControlQuery(), QueryOrigin.TargetCluster.CONTROL, this.getConfiguration(QueryOrigin.TargetCluster.CONTROL), this.getVerificationContext());
                    test = this.queryRewriter.rewriteQuery(this.sourceQuery.getTestQuery(), QueryOrigin.TargetCluster.TEST, this.getConfiguration(QueryOrigin.TargetCluster.TEST), this.getVerificationContext());
                    verificationResult = this.verify(control, test);
                    deterministic = verificationResult.getMatchResult().isMismatchPossiblyCausedByNonDeterminism() ? this.isDeterministic(control, verificationResult.getMatchResult().getControlChecksum()) : Optional.empty();
                    resultMismatched = deterministic.orElse(true) != false && !verificationResult.getMatchResult().isMatched();
                    optional = Optional.of(this.buildEvent(Optional.of(control), Optional.of(test), Optional.of(this.queryStats.get((Object)QueryOrigin.TargetCluster.CONTROL)), Optional.of(this.queryStats.get((Object)QueryOrigin.TargetCluster.TEST)), Optional.empty(), Optional.of(verificationResult), deterministic));
                    if (resultMismatched && !this.runTearDownOnResultMismatch) break block16;
                    if (control == null) break block17;
                }
                catch (QueryException e) {
                    Optional<VerifierQueryEvent> optional2 = Optional.of(this.buildEvent(Optional.ofNullable(control), Optional.ofNullable(test), Optional.ofNullable(this.queryStats.get((Object)QueryOrigin.TargetCluster.CONTROL)), Optional.ofNullable(this.queryStats.get((Object)QueryOrigin.TargetCluster.TEST)), Optional.of(e), Optional.ofNullable(verificationResult), deterministic));
                    if (!resultMismatched || this.runTearDownOnResultMismatch) {
                        if (control != null) {
                            this.teardownSafely(control, QueryOrigin.TargetCluster.CONTROL);
                        }
                        if (test != null) {
                            this.teardownSafely(test, QueryOrigin.TargetCluster.TEST);
                        }
                    }
                    return optional2;
                }
                catch (Throwable t) {
                    log.error(t);
                    Optional<VerifierQueryEvent> optional3 = Optional.empty();
                    if (!resultMismatched || this.runTearDownOnResultMismatch) {
                        if (control != null) {
                            this.teardownSafely(control, QueryOrigin.TargetCluster.CONTROL);
                        }
                        if (test != null) {
                            this.teardownSafely(test, QueryOrigin.TargetCluster.TEST);
                        }
                    }
                    return optional3;
                    {
                        catch (Throwable throwable) {
                            if (!resultMismatched || this.runTearDownOnResultMismatch) {
                                if (control != null) {
                                    this.teardownSafely(control, QueryOrigin.TargetCluster.CONTROL);
                                }
                                if (test != null) {
                                    this.teardownSafely(test, QueryOrigin.TargetCluster.TEST);
                                }
                            }
                            throw throwable;
                        }
                    }
                }
                this.teardownSafely(control, QueryOrigin.TargetCluster.CONTROL);
            }
            if (test != null) {
                this.teardownSafely(test, QueryOrigin.TargetCluster.TEST);
            }
        }
        return optional;
    }

    protected PrestoAction getPrestoAction() {
        return this.prestoAction;
    }

    protected QueryRewriter getQueryRewriter() {
        return this.queryRewriter;
    }

    protected SourceQuery getSourceQuery() {
        return this.sourceQuery;
    }

    protected QueryConfiguration getConfiguration(QueryOrigin.TargetCluster cluster) {
        Preconditions.checkState((cluster == QueryOrigin.TargetCluster.CONTROL || cluster == QueryOrigin.TargetCluster.TEST ? 1 : 0) != 0, (String)"Unexpected TargetCluster %s", (Object)((Object)cluster));
        return cluster == QueryOrigin.TargetCluster.CONTROL ? this.sourceQuery.getControlConfiguration() : this.sourceQuery.getTestConfiguration();
    }

    protected void setup(QueryBundle control, QueryOrigin.TargetCluster cluster) {
        for (Statement setupQuery : control.getSetupQueries()) {
            this.prestoAction.execute(setupQuery, this.getConfiguration(cluster), QueryOrigin.forSetup(cluster), this.getVerificationContext());
        }
    }

    protected void teardownSafely(QueryBundle control, QueryOrigin.TargetCluster cluster) {
        for (Statement teardownQuery : control.getTeardownQueries()) {
            try {
                this.prestoAction.execute(teardownQuery, this.getConfiguration(cluster), QueryOrigin.forTeardown(cluster), this.getVerificationContext());
            }
            catch (Throwable t) {
                log.warn("Failed to teardown %s: %s", new Object[]{cluster.name().toLowerCase(Locale.ENGLISH), AbstractVerification.formatSql(teardownQuery)});
            }
        }
    }

    private VerifierQueryEvent buildEvent(Optional<QueryBundle> control, Optional<QueryBundle> test, Optional<QueryStats> controlStats, Optional<QueryStats> testStats, Optional<QueryException> queryException, Optional<VerificationResult> verificationResult, Optional<Boolean> deterministic) {
        VerifierQueryEvent.EventStatus status;
        boolean succeeded = verificationResult.isPresent() && verificationResult.get().getMatchResult().isMatched();
        QueryState controlState = AbstractVerification.getQueryState(controlStats, queryException, QueryOrigin.TargetCluster.CONTROL);
        QueryState testState = AbstractVerification.getQueryState(testStats, queryException, QueryOrigin.TargetCluster.TEST);
        String errorMessage = null;
        if (!succeeded) {
            errorMessage = String.format("Test state %s, Control state %s\n", testState.name(), controlState.name());
            if (queryException.isPresent()) {
                errorMessage = errorMessage + Throwables.getStackTraceAsString((Throwable)queryException.get().getCause());
            }
            if (verificationResult.isPresent()) {
                errorMessage = errorMessage + verificationResult.get().getMatchResult().getResultsComparison();
            }
        }
        Optional<String> resolveMessage = Optional.empty();
        if (succeeded) {
            status = VerifierQueryEvent.EventStatus.SUCCEEDED;
        } else if (AbstractVerification.isSkipped(controlState, deterministic)) {
            status = VerifierQueryEvent.EventStatus.SKIPPED;
        } else {
            if (controlState == QueryState.SUCCEEDED && queryException.isPresent()) {
                Preconditions.checkState((boolean)controlStats.isPresent(), (Object)"control succeeded but control stats is missing");
                resolveMessage = this.resolveFailure(controlStats.get(), queryException.get());
            }
            status = resolveMessage.isPresent() ? VerifierQueryEvent.EventStatus.FAILED_RESOLVED : VerifierQueryEvent.EventStatus.FAILED;
        }
        controlStats = queryException.isPresent() && queryException.get().getQueryOrigin().equals(QueryOrigin.forMain(QueryOrigin.TargetCluster.CONTROL)) ? queryException.get().getQueryStats() : controlStats;
        testStats = queryException.isPresent() && queryException.get().getQueryOrigin().equals(QueryOrigin.forMain(QueryOrigin.TargetCluster.TEST)) ? queryException.get().getQueryStats() : testStats;
        Optional<String> errorCode = Optional.empty();
        if (!succeeded) {
            errorCode = Optional.ofNullable(queryException.map(QueryException::getErrorCode).orElse(verificationResult.map(VerificationResult::getMatchResult).map(MatchResult::getMatchType).map(Enum::name).orElse(null)));
        }
        return new VerifierQueryEvent(this.sourceQuery.getSuite(), this.testId, this.sourceQuery.getName(), status, deterministic, resolveMessage, AbstractVerification.buildQueryInfo(this.sourceQuery.getControlConfiguration(), this.sourceQuery.getControlQuery(), verificationResult.map(VerificationResult::getControlChecksumQueryId), verificationResult.map(VerificationResult::getControlChecksumQuery), control, controlStats, this.verificationContext.getAllFailures(QueryOrigin.TargetCluster.CONTROL)), AbstractVerification.buildQueryInfo(this.sourceQuery.getTestConfiguration(), this.sourceQuery.getTestQuery(), verificationResult.map(VerificationResult::getTestChecksumQueryId), verificationResult.map(VerificationResult::getTestChecksumQuery), test, testStats, this.verificationContext.getAllFailures(QueryOrigin.TargetCluster.TEST)), errorCode, Optional.ofNullable(errorMessage));
    }

    private Optional<String> resolveFailure(QueryStats controlStats, QueryException queryException) {
        if (!this.failureResolverEnabled) {
            return Optional.empty();
        }
        for (FailureResolver failureResolver : this.failureResolvers) {
            Optional<String> resolveMessage = failureResolver.resolve(controlStats, queryException);
            if (!resolveMessage.isPresent()) continue;
            return resolveMessage;
        }
        return Optional.empty();
    }

    private static QueryInfo buildQueryInfo(QueryConfiguration configuration, String originalQuery, Optional<String> checksumQueryId, Optional<String> checksumQuery, Optional<QueryBundle> queryBundle, Optional<QueryStats> queryStats, List<FailureInfo> allFailures) {
        return new QueryInfo(configuration.getCatalog(), configuration.getSchema(), originalQuery, queryStats.map(QueryStats::getQueryId), checksumQueryId, queryBundle.map(QueryBundle::getQuery).map(AbstractVerification::formatSql), queryBundle.map(QueryBundle::getSetupQueries).map(AbstractVerification::formatSqls), queryBundle.map(QueryBundle::getTeardownQueries).map(AbstractVerification::formatSqls), checksumQuery, AbstractVerification.millisToSeconds(queryStats.map(QueryStats::getCpuTimeMillis)), AbstractVerification.millisToSeconds(queryStats.map(QueryStats::getWallTimeMillis)), allFailures);
    }

    protected static String formatSql(Statement statement) {
        return SqlFormatter.formatSql((Node)statement, Optional.empty());
    }

    protected static List<String> formatSqls(List<Statement> statements) {
        return (List)statements.stream().map(AbstractVerification::formatSql).collect(ImmutableList.toImmutableList());
    }

    private static boolean isSkipped(QueryState controlState, Optional<Boolean> deterministic) {
        if (controlState == QueryState.FAILED || controlState == QueryState.FAILED_TO_SETUP || controlState == QueryState.TIMED_OUT || controlState == QueryState.NOT_RUN) {
            return true;
        }
        return deterministic.orElse(true) == false;
    }

    private static Optional<Double> millisToSeconds(Optional<Long> millis) {
        return millis.map(value -> new Duration((double)value.longValue(), TimeUnit.MILLISECONDS).getValue(TimeUnit.SECONDS));
    }

    private static QueryState getQueryState(Optional<QueryStats> statsFromResult, Optional<QueryException> queryException, QueryOrigin.TargetCluster cluster) {
        if (statsFromResult.isPresent()) {
            return QueryState.SUCCEEDED;
        }
        if (!queryException.isPresent() || queryException.get().getQueryOrigin().getCluster() != cluster) {
            return QueryState.NOT_RUN;
        }
        if (queryException.get().getQueryOrigin().getStage() == QueryOrigin.QueryStage.SETUP) {
            return QueryState.FAILED_TO_SETUP;
        }
        if (queryException.get().getQueryOrigin().getStage() == QueryOrigin.QueryStage.MAIN) {
            return queryException.get().getPrestoErrorCode().map(errorCode -> errorCode == StandardErrorCode.EXCEEDED_TIME_LIMIT).orElse(false) != false ? QueryState.TIMED_OUT : QueryState.FAILED;
        }
        if (queryException.get().getQueryOrigin().getStage() == QueryOrigin.QueryStage.TEARDOWN) {
            return QueryState.FAILED_TO_TEARDOWN;
        }
        return QueryState.NOT_RUN;
    }

    private static enum QueryState {
        SUCCEEDED,
        FAILED,
        TIMED_OUT,
        FAILED_TO_SETUP,
        FAILED_TO_TEARDOWN,
        NOT_RUN;

    }
}

