/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.event;

import com.facebook.presto.verifier.event.QueryInfo;
import io.airlift.event.client.EventField;
import io.airlift.event.client.EventType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@EventType(value="VerifierQuery")
@Immutable
public class VerifierQueryEvent {
    private final String suite;
    private final String testId;
    private final String name;
    private final String status;
    private final Boolean deterministic;
    private final String resolveMessage;
    private final QueryInfo controlQueryInfo;
    private final QueryInfo testQueryInfo;
    private final String errorCode;
    private final String errorMessage;

    public VerifierQueryEvent(String suite, String testId, String name, EventStatus status, Optional<Boolean> deterministic, Optional<String> resolveMessage, QueryInfo controlQueryInfo, QueryInfo testQueryInfo, Optional<String> errorCode, Optional<String> errorMessage) {
        this.suite = Objects.requireNonNull(suite, "suite is null");
        this.testId = Objects.requireNonNull(testId, "testId is null");
        this.name = Objects.requireNonNull(name, "name is null");
        this.status = status.name();
        this.deterministic = deterministic.orElse(null);
        this.resolveMessage = resolveMessage.orElse(null);
        this.controlQueryInfo = Objects.requireNonNull(controlQueryInfo, "controlQueryInfo is null");
        this.testQueryInfo = Objects.requireNonNull(testQueryInfo, "testQueryInfo is null");
        this.errorCode = errorCode.orElse(null);
        this.errorMessage = errorMessage.orElse(null);
    }

    @EventField
    public String getSuite() {
        return this.suite;
    }

    @EventField
    public String getTestId() {
        return this.testId;
    }

    @EventField
    public String getName() {
        return this.name;
    }

    @EventField
    public String getStatus() {
        return this.status;
    }

    @EventField
    public Boolean getDeterministic() {
        return this.deterministic;
    }

    @EventField
    public String getResolveMessage() {
        return this.resolveMessage;
    }

    @EventField
    public QueryInfo getControlQueryInfo() {
        return this.controlQueryInfo;
    }

    @EventField
    public QueryInfo getTestQueryInfo() {
        return this.testQueryInfo;
    }

    @EventField
    public String getErrorCode() {
        return this.errorCode;
    }

    @EventField
    public String getErrorMessage() {
        return this.errorMessage;
    }

    public static enum EventStatus {
        SUCCEEDED,
        FAILED,
        FAILED_RESOLVED,
        SKIPPED;

    }
}

