/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.event;

import com.facebook.presto.verifier.framework.QueryOrigin;
import io.airlift.event.client.EventField;
import io.airlift.event.client.EventType;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.concurrent.Immutable;

@EventType(value="QueryInfo")
@Immutable
public class FailureInfo {
    private final String queryStage;
    private final String errorCode;
    private final String prestoQueryId;
    private final String stacktrace;

    public FailureInfo(QueryOrigin.QueryStage queryStage, String errorCode, Optional<String> prestoQueryId, String stacktrace) {
        this.queryStage = queryStage.name();
        this.errorCode = Objects.requireNonNull(errorCode, "errorCode is null");
        this.prestoQueryId = prestoQueryId.orElse(null);
        this.stacktrace = Objects.requireNonNull(stacktrace, "stacktrace is null");
    }

    @EventField
    public String getQueryStage() {
        return this.queryStage;
    }

    @EventField
    public String getErrorCode() {
        return this.errorCode;
    }

    @EventField
    public String getPrestoQueryId() {
        return this.prestoQueryId;
    }

    @EventField
    public String getStacktrace() {
        return this.stacktrace;
    }
}

