/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier.checksum;

import com.facebook.presto.spi.type.ArrayType;
import com.facebook.presto.spi.type.RowType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.sql.tree.CoalesceExpression;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.TryExpression;
import com.facebook.presto.verifier.checksum.ChecksumResult;
import com.facebook.presto.verifier.checksum.ColumnMatchResult;
import com.facebook.presto.verifier.checksum.ColumnValidator;
import com.facebook.presto.verifier.framework.Column;
import com.facebook.presto.verifier.framework.VerifierUtil;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import javax.inject.Inject;

public class OrderableArrayColumnValidator
implements ColumnValidator {
    @Inject
    public OrderableArrayColumnValidator() {
    }

    @Override
    public List<SingleColumn> generateChecksumColumns(Column column) {
        Preconditions.checkArgument((boolean)(column.getType() instanceof ArrayType), (String)"Expect ArrayType, found %s", (Object)column.getType().getDisplayName());
        Type elementType = ((ArrayType)column.getType()).getElementType();
        FunctionCall arraySort = new FunctionCall(QualifiedName.of((String)"array_sort"), (List)ImmutableList.of((Object)column.getIdentifier()));
        Object checksum = elementType instanceof ArrayType || elementType instanceof RowType ? new CoalesceExpression((Expression)new FunctionCall(QualifiedName.of((String)"checksum"), (List)ImmutableList.of((Object)new TryExpression((Expression)arraySort))), (Expression)new FunctionCall(QualifiedName.of((String)"checksum"), (List)ImmutableList.of((Object)column.getIdentifier())), new Expression[0]) : new FunctionCall(QualifiedName.of((String)"checksum"), (List)ImmutableList.of((Object)arraySort));
        return ImmutableList.of((Object)new SingleColumn((Expression)checksum, Optional.of(VerifierUtil.delimitedIdentifier(OrderableArrayColumnValidator.getChecksumColumnAlias(column)))));
    }

    @Override
    public ColumnMatchResult validate(Column column, ChecksumResult controlResult, ChecksumResult testResult) {
        String sortedChecksumColumnAlias = OrderableArrayColumnValidator.getChecksumColumnAlias(column);
        Object controlSortedChecksum = controlResult.getChecksum(sortedChecksumColumnAlias);
        Object testSortedChecksum = testResult.getChecksum(sortedChecksumColumnAlias);
        return new ColumnMatchResult(Objects.equals(controlSortedChecksum, testSortedChecksum), String.format("control(checksum: %s) test(checksum: %s)", controlSortedChecksum, testSortedChecksum));
    }

    private static String getChecksumColumnAlias(Column column) {
        return column.getName() + "_checksum";
    }
}

