/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier;

import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.verifier.QueryType;
import com.google.common.base.Splitter;
import com.google.common.base.Strings;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import io.airlift.configuration.Config;
import io.airlift.configuration.ConfigDescription;
import io.airlift.configuration.LegacyConfig;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Objects;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import javax.annotation.Nullable;
import javax.validation.constraints.Min;
import javax.validation.constraints.NotNull;
import org.joda.time.DateTime;

public class VerifierConfig {
    private String testUsernameOverride;
    private String controlUsernameOverride;
    private String testPasswordOverride;
    private String controlPasswordOverride;
    private List<String> suites;
    private Set<QueryType> controlQueryTypes = ImmutableSet.of((Object)((Object)QueryType.READ), (Object)((Object)QueryType.CREATE), (Object)((Object)QueryType.MODIFY));
    private Set<QueryType> testQueryTypes = ImmutableSet.of((Object)((Object)QueryType.READ), (Object)((Object)QueryType.CREATE), (Object)((Object)QueryType.MODIFY));
    private String source;
    private String runId = new DateTime().toString("yyyy-MM-dd");
    private Set<String> eventClients = ImmutableSet.of((Object)"human-readable");
    private int threadCount = 10;
    private String queryDatabase;
    private String controlGateway;
    private String testGateway;
    private Duration controlTimeout = new Duration(10.0, TimeUnit.MINUTES);
    private Duration testTimeout = new Duration(1.0, TimeUnit.HOURS);
    private Set<String> blacklist = ImmutableSet.of();
    private Set<String> whitelist = ImmutableSet.of();
    private int maxRowCount = 10000;
    private int maxQueries = 1000000;
    private boolean alwaysReport;
    private String eventLogFile;
    private int suiteRepetitions = 1;
    private int queryRepetitions = 1;
    private String skipCorrectnessRegex = "^$";
    private boolean checkCorrectness = true;
    private String skipCpuCheckRegex = "(?i)(?s).*LIMIT.*";
    private boolean checkCpu = true;
    private boolean explainOnly;
    private boolean verboseResultsComparison;
    private String testCatalogOverride;
    private String testSchemaOverride;
    private String controlCatalogOverride;
    private String controlSchemaOverride;
    private boolean quiet;
    private String additionalJdbcDriverPath;
    private String testJdbcDriverName;
    private String controlJdbcDriverName;
    private int doublePrecision = 3;
    private int controlTeardownRetries = 1;
    private int testTeardownRetries = 1;
    private boolean shadowWrites = true;
    private String shadowTestTablePrefix = "tmp_verifier_";
    private String shadowControlTablePrefix = "tmp_verifier_";
    private boolean runTearDownOnResultMismatch;
    private Duration regressionMinCpuTime = new Duration(5.0, TimeUnit.MINUTES);

    @NotNull
    public String getSkipCorrectnessRegex() {
        return this.skipCorrectnessRegex;
    }

    @ConfigDescription(value="Correctness check will be skipped if this regex matches query")
    @Config(value="skip-correctness-regex")
    public VerifierConfig setSkipCorrectnessRegex(String skipCorrectnessRegex) {
        this.skipCorrectnessRegex = skipCorrectnessRegex;
        return this;
    }

    @NotNull
    public String getSkipCpuCheckRegex() {
        return this.skipCpuCheckRegex;
    }

    @ConfigDescription(value="CPU check will be skipped if this regex matches query")
    @Config(value="skip-cpu-check-regex")
    public VerifierConfig setSkipCpuCheckRegex(String skipCpuCheckRegex) {
        this.skipCpuCheckRegex = skipCpuCheckRegex;
        return this;
    }

    public boolean isVerboseResultsComparison() {
        return this.verboseResultsComparison;
    }

    @ConfigDescription(value="Display a diff of results that don't match")
    @Config(value="verbose-results-comparison")
    public VerifierConfig setVerboseResultsComparison(boolean verboseResultsComparison) {
        this.verboseResultsComparison = verboseResultsComparison;
        return this;
    }

    public boolean isQuiet() {
        return this.quiet;
    }

    @ConfigDescription(value="Reduces the number of informational messages printed")
    @Config(value="quiet")
    public VerifierConfig setQuiet(boolean quiet) {
        this.quiet = quiet;
        return this;
    }

    public int getQueryRepetitions() {
        return this.queryRepetitions;
    }

    @ConfigDescription(value="The number of times to repeat each query")
    @Config(value="query-repetitions")
    public VerifierConfig setQueryRepetitions(int queryRepetitions) {
        this.queryRepetitions = queryRepetitions;
        return this;
    }

    public String getSuite() {
        return this.suites == null ? null : this.suites.get(0);
    }

    @ConfigDescription(value="The suites of queries in the query database to run")
    @Config(value="suite")
    public VerifierConfig setSuite(String suite) {
        if (suite == null) {
            return this;
        }
        this.suites = ImmutableList.of((Object)suite);
        return this;
    }

    public Set<QueryType> getControlQueryTypes() {
        return this.controlQueryTypes;
    }

    @ConfigDescription(value="The types of control queries allowed to run [CREATE, READ, MODIFY]")
    @Config(value="control.query-types")
    public VerifierConfig setControlQueryTypes(String types) {
        if (Strings.isNullOrEmpty((String)types)) {
            this.controlQueryTypes = ImmutableSet.of();
            return this;
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String value : Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)types)) {
            builder.add((Object)QueryType.valueOf(value.toUpperCase()));
        }
        this.controlQueryTypes = builder.build();
        return this;
    }

    public Set<QueryType> getTestQueryTypes() {
        return this.testQueryTypes;
    }

    @ConfigDescription(value="The types of control queries allowed to run [CREATE, READ, MODIFY]")
    @Config(value="test.query-types")
    public VerifierConfig setTestQueryTypes(String types) {
        if (Strings.isNullOrEmpty((String)types)) {
            this.testQueryTypes = ImmutableSet.of();
            return this;
        }
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String value : Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)types)) {
            builder.add((Object)QueryType.valueOf(value.toUpperCase()));
        }
        this.testQueryTypes = builder.build();
        return this;
    }

    @NotNull
    public List<String> getSuites() {
        return this.suites;
    }

    @ConfigDescription(value="The suites of queries in the query database to run")
    @Config(value="suites")
    public VerifierConfig setSuites(String suites) {
        if (Strings.isNullOrEmpty((String)suites)) {
            return this;
        }
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String value : Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)suites)) {
            builder.add((Object)value);
        }
        this.suites = builder.build();
        return this;
    }

    @Min(value=1L)
    public int getThreadCount() {
        return this.threadCount;
    }

    @ConfigDescription(value="The concurrency level")
    @Config(value="thread-count")
    public VerifierConfig setThreadCount(int threadCount) {
        this.threadCount = threadCount;
        return this;
    }

    @NotNull
    public String getQueryDatabase() {
        return this.queryDatabase;
    }

    @ConfigDescription(value="Database to fetch query suites from")
    @Config(value="query-database")
    public VerifierConfig setQueryDatabase(String queryDatabase) {
        this.queryDatabase = queryDatabase;
        return this;
    }

    @NotNull
    public Set<String> getBlacklist() {
        return this.blacklist;
    }

    @ConfigDescription(value="Names of queries which are blacklisted")
    @Config(value="blacklist")
    public VerifierConfig setBlacklist(String blacklist) {
        ImmutableSet.Builder blacklistBuilder = ImmutableSet.builder();
        for (String value : Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)blacklist)) {
            blacklistBuilder.add((Object)value);
        }
        this.blacklist = blacklistBuilder.build();
        return this;
    }

    @NotNull
    public Set<String> getWhitelist() {
        return this.whitelist;
    }

    @ConfigDescription(value="Names of queries which are whitelisted. Whitelist is applied before the blacklist")
    @Config(value="whitelist")
    public VerifierConfig setWhitelist(String whitelist) {
        ImmutableSet.Builder whitelistBuilder = ImmutableSet.builder();
        for (String value : Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)whitelist)) {
            whitelistBuilder.add((Object)value);
        }
        this.whitelist = whitelistBuilder.build();
        return this;
    }

    @Min(value=1L)
    public int getMaxRowCount() {
        return this.maxRowCount;
    }

    @ConfigDescription(value="The maximum number of rows a query may return. If it exceeds this limit it's marked as failed")
    @Config(value="max-row-count")
    public VerifierConfig setMaxRowCount(int maxRowCount) {
        this.maxRowCount = maxRowCount;
        return this;
    }

    public boolean isAlwaysReport() {
        return this.alwaysReport;
    }

    @ConfigDescription(value="Print more informational messages")
    @Config(value="always-report")
    public VerifierConfig setAlwaysReport(boolean alwaysReport) {
        this.alwaysReport = alwaysReport;
        return this;
    }

    public int getMaxQueries() {
        return this.maxQueries;
    }

    @ConfigDescription(value="The maximum number of queries to run for each suite")
    @Config(value="max-queries")
    public VerifierConfig setMaxQueries(int maxQueries) {
        this.maxQueries = maxQueries;
        return this;
    }

    public boolean isCheckCorrectnessEnabled() {
        return this.checkCorrectness;
    }

    @ConfigDescription(value="Whether to check that the rows from control and test match")
    @Config(value="check-correctness")
    public VerifierConfig setCheckCorrectnessEnabled(boolean checkCorrectness) {
        this.checkCorrectness = checkCorrectness;
        return this;
    }

    public boolean isCheckCpuEnabled() {
        return this.checkCpu;
    }

    @ConfigDescription(value="Whether to check that CPU from control and test match")
    @Config(value="check-cpu")
    public VerifierConfig setCheckCpuEnabled(boolean checkCpu) {
        this.checkCpu = checkCpu;
        return this;
    }

    public boolean isExplainOnly() {
        return this.explainOnly;
    }

    @ConfigDescription(value="Only attempt to explain queries but do not execute them")
    @Config(value="explain-only")
    public VerifierConfig setExplainOnly(boolean explainOnly) {
        this.explainOnly = explainOnly;
        return this;
    }

    public int getSuiteRepetitions() {
        return this.suiteRepetitions;
    }

    @ConfigDescription(value="Number of times to run each suite")
    @Config(value="suite-repetitions")
    public VerifierConfig setSuiteRepetitions(int suiteRepetitions) {
        this.suiteRepetitions = suiteRepetitions;
        return this;
    }

    @NotNull
    public Set<String> getEventClients() {
        return this.eventClients;
    }

    @ConfigDescription(value="The event client(s) to log the results to")
    @Config(value="event-client")
    public VerifierConfig setEventClients(String eventClients) {
        Objects.requireNonNull(eventClients, "eventClients is null");
        ImmutableSet.Builder builder = ImmutableSet.builder();
        for (String value : Splitter.on((char)',').trimResults().omitEmptyStrings().split((CharSequence)eventClients)) {
            builder.add((Object)value);
        }
        this.eventClients = builder.build();
        return this;
    }

    public String getSource() {
        return this.source;
    }

    @ConfigDescription(value="The source to pass to Presto")
    @Config(value="source")
    public VerifierConfig setSource(String source) {
        this.source = source;
        return this;
    }

    public String getRunId() {
        return this.runId;
    }

    @ConfigDescription(value="A customizable string that will be logged with the results")
    @Config(value="run-id")
    public VerifierConfig setRunId(String runId) {
        this.runId = runId;
        return this;
    }

    public String getEventLogFile() {
        return this.eventLogFile;
    }

    @ConfigDescription(value="The file to log events to. Used with event-client=file")
    @Config(value="event-log-file")
    public VerifierConfig setEventLogFile(String eventLogFile) {
        this.eventLogFile = eventLogFile;
        return this;
    }

    public String getTestCatalogOverride() {
        return this.testCatalogOverride;
    }

    @ConfigDescription(value="Overrides the test_catalog field in all queries in the suites")
    @Config(value="test.catalog-override")
    public VerifierConfig setTestCatalogOverride(String testCatalogOverride) {
        this.testCatalogOverride = testCatalogOverride;
        return this;
    }

    public String getTestSchemaOverride() {
        return this.testSchemaOverride;
    }

    @ConfigDescription(value="Overrides the test_schema field in all queries in the suites")
    @Config(value="test.schema-override")
    public VerifierConfig setTestSchemaOverride(String testSchemaOverride) {
        this.testSchemaOverride = testSchemaOverride;
        return this;
    }

    public Duration getTestTimeout() {
        return this.testTimeout;
    }

    @ConfigDescription(value="Timeout for queries to the test cluster")
    @Config(value="test.timeout")
    public VerifierConfig setTestTimeout(Duration testTimeout) {
        this.testTimeout = testTimeout;
        return this;
    }

    @Nullable
    public String getTestUsernameOverride() {
        return this.testUsernameOverride;
    }

    @ConfigDescription(value="Username for test cluster")
    @Config(value="test.username-override")
    @LegacyConfig(value={"test.username"})
    public VerifierConfig setTestUsernameOverride(String testUsernameOverride) {
        this.testUsernameOverride = testUsernameOverride;
        return this;
    }

    @Nullable
    public String getTestPasswordOverride() {
        return this.testPasswordOverride;
    }

    @ConfigDescription(value="Password for test cluster")
    @Config(value="test.password-override")
    @LegacyConfig(value={"test.password"})
    public VerifierConfig setTestPasswordOverride(String testPasswordOverride) {
        this.testPasswordOverride = testPasswordOverride;
        return this;
    }

    @NotNull
    public String getTestGateway() {
        return this.testGateway;
    }

    @ConfigDescription(value="URL for test cluster")
    @Config(value="test.gateway")
    public VerifierConfig setTestGateway(String testGateway) {
        this.testGateway = testGateway;
        return this;
    }

    public String getControlCatalogOverride() {
        return this.controlCatalogOverride;
    }

    @ConfigDescription(value="Overrides the control_catalog field in all queries in the suites")
    @Config(value="control.catalog-override")
    public VerifierConfig setControlCatalogOverride(String controlCatalogOverride) {
        this.controlCatalogOverride = controlCatalogOverride;
        return this;
    }

    public String getControlSchemaOverride() {
        return this.controlSchemaOverride;
    }

    @ConfigDescription(value="Overrides the control_schema field in all queries in the suites")
    @Config(value="control.schema-override")
    public VerifierConfig setControlSchemaOverride(String controlSchemaOverride) {
        this.controlSchemaOverride = controlSchemaOverride;
        return this;
    }

    public Duration getControlTimeout() {
        return this.controlTimeout;
    }

    @ConfigDescription(value="Timeout for queries to the control cluster")
    @Config(value="control.timeout")
    public VerifierConfig setControlTimeout(Duration controlTimeout) {
        this.controlTimeout = controlTimeout;
        return this;
    }

    @Nullable
    public String getControlUsernameOverride() {
        return this.controlUsernameOverride;
    }

    @ConfigDescription(value="Username for control cluster")
    @Config(value="control.username-override")
    @LegacyConfig(value={"control.username"})
    public VerifierConfig setControlUsernameOverride(String controlUsernameOverride) {
        this.controlUsernameOverride = controlUsernameOverride;
        return this;
    }

    @Nullable
    public String getControlPasswordOverride() {
        return this.controlPasswordOverride;
    }

    @ConfigDescription(value="Password for control cluster")
    @Config(value="control.password-override")
    @LegacyConfig(value={"control.password"})
    public VerifierConfig setControlPasswordOverride(String controlPasswordOverride) {
        this.controlPasswordOverride = controlPasswordOverride;
        return this;
    }

    @NotNull
    public String getControlGateway() {
        return this.controlGateway;
    }

    @ConfigDescription(value="URL for control cluster")
    @Config(value="control.gateway")
    public VerifierConfig setControlGateway(String controlGateway) {
        this.controlGateway = controlGateway;
        return this;
    }

    @Nullable
    public String getAdditionalJdbcDriverPath() {
        return this.additionalJdbcDriverPath;
    }

    @ConfigDescription(value="Path for test jdbc driver")
    @Config(value="additional-jdbc-driver-path")
    public VerifierConfig setAdditionalJdbcDriverPath(String path) {
        this.additionalJdbcDriverPath = path;
        return this;
    }

    @Nullable
    public String getTestJdbcDriverName() {
        return this.testJdbcDriverName;
    }

    @ConfigDescription(value="Fully qualified test JDBC driver name")
    @Config(value="test.jdbc-driver-class")
    public VerifierConfig setTestJdbcDriverName(String testJdbcDriverName) {
        this.testJdbcDriverName = testJdbcDriverName;
        return this;
    }

    @Nullable
    public String getControlJdbcDriverName() {
        return this.controlJdbcDriverName;
    }

    @ConfigDescription(value="Fully qualified control JDBC driver name")
    @Config(value="control.jdbc-driver-class")
    public VerifierConfig setControlJdbcDriverName(String controlJdbcDriverName) {
        this.controlJdbcDriverName = controlJdbcDriverName;
        return this;
    }

    public int getDoublePrecision() {
        return this.doublePrecision;
    }

    @ConfigDescription(value="The expected precision when comparing test and control results")
    @Config(value="expected-double-precision")
    public VerifierConfig setDoublePrecision(int doublePrecision) {
        this.doublePrecision = doublePrecision;
        return this;
    }

    @NotNull
    public Duration getRegressionMinCpuTime() {
        return this.regressionMinCpuTime;
    }

    @ConfigDescription(value="Minimum cpu time a query must use in the control to be considered for regression")
    @Config(value="regression.min-cpu-time")
    public VerifierConfig setRegressionMinCpuTime(Duration regressionMinCpuTime) {
        this.regressionMinCpuTime = regressionMinCpuTime;
        return this;
    }

    @Min(value=0L)
    public int getControlTeardownRetries() {
        return this.controlTeardownRetries;
    }

    @ConfigDescription(value="Number of retries for control teardown queries")
    @Config(value="control.teardown-retries")
    public VerifierConfig setControlTeardownRetries(int controlTeardownRetries) {
        this.controlTeardownRetries = controlTeardownRetries;
        return this;
    }

    @Min(value=0L)
    public int getTestTeardownRetries() {
        return this.testTeardownRetries;
    }

    @ConfigDescription(value="Number of retries for test teardown queries")
    @Config(value="test.teardown-retries")
    public VerifierConfig setTestTeardownRetries(int testTeardownRetries) {
        this.testTeardownRetries = testTeardownRetries;
        return this;
    }

    public boolean getShadowWrites() {
        return this.shadowWrites;
    }

    @ConfigDescription(value="Modify write queries to write to a temporary table instead")
    @Config(value="shadow-writes.enabled")
    public VerifierConfig setShadowWrites(boolean shadowWrites) {
        this.shadowWrites = shadowWrites;
        return this;
    }

    public QualifiedName getShadowTestTablePrefix() {
        return QualifiedName.of((Iterable)Splitter.on((String)".").splitToList((CharSequence)this.shadowTestTablePrefix));
    }

    @ConfigDescription(value="The prefix to use for temporary test shadow tables. May be fully qualified like 'tmp_catalog.tmp_schema.tmp_'")
    @Config(value="shadow-writes.test-table-prefix")
    public VerifierConfig setShadowTestTablePrefix(String prefix) {
        this.shadowTestTablePrefix = prefix;
        return this;
    }

    public QualifiedName getShadowControlTablePrefix() {
        return QualifiedName.of((Iterable)Splitter.on((String)".").splitToList((CharSequence)this.shadowControlTablePrefix));
    }

    @ConfigDescription(value="The prefix to use for temporary control shadow tables. May be fully qualified like 'tmp_catalog.tmp_schema.tmp_'")
    @Config(value="shadow-writes.control-table-prefix")
    public VerifierConfig setShadowControlTablePrefix(String prefix) {
        this.shadowControlTablePrefix = prefix;
        return this;
    }

    public boolean getRunTearDownOnResultMismatch() {
        return this.runTearDownOnResultMismatch;
    }

    @ConfigDescription(value="If set to false, temporary tables will not be dropped after checksum failure")
    @Config(value="run-teardown-on-result-mismatch")
    public VerifierConfig setRunTearDownOnResultMismatch(boolean runTearDownOnResultMismatch) {
        this.runTearDownOnResultMismatch = runTearDownOnResultMismatch;
        return this;
    }
}

