/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier;

import com.facebook.presto.sql.SqlFormatter;
import com.facebook.presto.sql.parser.ParsingOptions;
import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.tree.CreateTable;
import com.facebook.presto.sql.tree.CreateTableAsSelect;
import com.facebook.presto.sql.tree.DropTable;
import com.facebook.presto.sql.tree.Expression;
import com.facebook.presto.sql.tree.FunctionCall;
import com.facebook.presto.sql.tree.Identifier;
import com.facebook.presto.sql.tree.Insert;
import com.facebook.presto.sql.tree.LikeClause;
import com.facebook.presto.sql.tree.LongLiteral;
import com.facebook.presto.sql.tree.Node;
import com.facebook.presto.sql.tree.QualifiedName;
import com.facebook.presto.sql.tree.QueryBody;
import com.facebook.presto.sql.tree.QuerySpecification;
import com.facebook.presto.sql.tree.Select;
import com.facebook.presto.sql.tree.SingleColumn;
import com.facebook.presto.sql.tree.Table;
import com.facebook.presto.verifier.Query;
import com.facebook.presto.verifier.QueryType;
import com.facebook.presto.verifier.VerifyCommand;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import com.google.common.util.concurrent.SimpleTimeLimiter;
import com.google.common.util.concurrent.UncheckedTimeoutException;
import io.airlift.units.Duration;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import java.util.UUID;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;

public class QueryRewriter {
    private static final Set<Integer> APPROXIMATE_TYPES = ImmutableSet.of((Object)7, (Object)6, (Object)8);
    private final SqlParser parser;
    private final String gatewayUrl;
    private final QualifiedName rewritePrefix;
    private final Optional<String> catalogOverride;
    private final Optional<String> schemaOverride;
    private final Optional<String> usernameOverride;
    private final Optional<String> passwordOverride;
    private final int doublePrecision;
    private final Duration timeout;

    public QueryRewriter(SqlParser parser, String gatewayUrl, QualifiedName rewritePrefix, Optional<String> catalogOverride, Optional<String> schemaOverride, Optional<String> usernameOverride, Optional<String> passwordOverride, int doublePrecision, Duration timeout) {
        this.parser = Objects.requireNonNull(parser, "parser is null");
        this.gatewayUrl = Objects.requireNonNull(gatewayUrl, "gatewayUrl is null");
        this.rewritePrefix = Objects.requireNonNull(rewritePrefix, "rewritePrefix is null");
        this.catalogOverride = Objects.requireNonNull(catalogOverride, "catalogOverride is null");
        this.schemaOverride = Objects.requireNonNull(schemaOverride, "schemaOverride is null");
        this.usernameOverride = Objects.requireNonNull(usernameOverride, "usernameOverride is null");
        this.passwordOverride = Objects.requireNonNull(passwordOverride, "passwordOverride is null");
        this.doublePrecision = doublePrecision;
        this.timeout = Objects.requireNonNull(timeout, "timeout is null");
    }

    public Query shadowQuery(Query query) throws QueryRewriteException, SQLException {
        if (VerifyCommand.statementToQueryType(this.parser, query.getQuery()) == QueryType.READ) {
            return query;
        }
        if (!query.getPreQueries().isEmpty()) {
            throw new QueryRewriteException("Cannot rewrite queries that use pre-queries", new Object[0]);
        }
        if (!query.getPostQueries().isEmpty()) {
            throw new QueryRewriteException("Cannot rewrite queries that use post-queries", new Object[0]);
        }
        com.facebook.presto.sql.tree.Statement statement = this.parser.createStatement(query.getQuery(), new ParsingOptions(ParsingOptions.DecimalLiteralTreatment.AS_DOUBLE));
        try (Connection connection = DriverManager.getConnection(this.gatewayUrl, this.usernameOverride.orElse(query.getUsername()), this.passwordOverride.orElse(query.getPassword()));){
            this.trySetConnectionProperties(query, connection);
            if (statement instanceof CreateTableAsSelect) {
                Query query2 = this.rewriteCreateTableAsSelect(connection, query, (CreateTableAsSelect)statement);
                return query2;
            }
            if (statement instanceof Insert) {
                Query query3 = this.rewriteInsertQuery(connection, query, (Insert)statement);
                return query3;
            }
        }
        throw new QueryRewriteException("Unsupported query type: " + statement.getClass(), new Object[0]);
    }

    private Query rewriteCreateTableAsSelect(Connection connection, Query query, CreateTableAsSelect statement) throws SQLException, QueryRewriteException {
        QualifiedName temporaryTableName = this.generateTemporaryTableName(statement.getName());
        CreateTableAsSelect rewritten = new CreateTableAsSelect(temporaryTableName, statement.getQuery(), statement.isNotExists(), statement.getProperties(), statement.isWithData(), statement.getColumnAliases(), Optional.empty());
        String createTableAsSql = SqlFormatter.formatSql((Node)rewritten, Optional.empty());
        String checksumSql = this.checksumSql(this.getColumns(connection, statement), temporaryTableName);
        String dropTableSql = QueryRewriter.dropTableSql(temporaryTableName);
        return new Query(query.getCatalog(), query.getSchema(), (List<String>)ImmutableList.of((Object)createTableAsSql), checksumSql, (List<String>)ImmutableList.of((Object)dropTableSql), query.getUsername(), query.getPassword(), query.getSessionProperties());
    }

    private Query rewriteInsertQuery(Connection connection, Query query, Insert statement) throws SQLException, QueryRewriteException {
        QualifiedName temporaryTableName = this.generateTemporaryTableName(statement.getTarget());
        CreateTable createTemporaryTable = new CreateTable(temporaryTableName, (List)ImmutableList.of((Object)new LikeClause(statement.getTarget(), Optional.of(LikeClause.PropertiesOption.INCLUDING))), true, (List)ImmutableList.of(), Optional.empty());
        String createTemporaryTableSql = SqlFormatter.formatSql((Node)createTemporaryTable, Optional.empty());
        String insertSql = SqlFormatter.formatSql((Node)new Insert(temporaryTableName, statement.getColumns(), statement.getQuery()), Optional.empty());
        String checksumSql = this.checksumSql(this.getColumnsForTable(connection, query.getCatalog(), query.getSchema(), statement.getTarget().toString()), temporaryTableName);
        String dropTableSql = QueryRewriter.dropTableSql(temporaryTableName);
        return new Query(query.getCatalog(), query.getSchema(), (List<String>)ImmutableList.of((Object)createTemporaryTableSql, (Object)insertSql), checksumSql, (List<String>)ImmutableList.of((Object)dropTableSql), query.getUsername(), query.getPassword(), query.getSessionProperties());
    }

    private QualifiedName generateTemporaryTableName(QualifiedName originalName) {
        int prefixSize;
        ArrayList parts = new ArrayList();
        int originalSize = originalName.getOriginalParts().size();
        if (originalSize > (prefixSize = this.rewritePrefix.getOriginalParts().size())) {
            parts.addAll(originalName.getOriginalParts().subList(0, originalSize - prefixSize));
        }
        parts.addAll(this.rewritePrefix.getOriginalParts());
        parts.set(parts.size() - 1, this.createTemporaryTableName());
        return QualifiedName.of(parts);
    }

    private void trySetConnectionProperties(Query query, Connection connection) throws SQLException {
        try {
            connection.setClientInfo("ApplicationName", "verifier-rewrite");
            connection.setCatalog(this.catalogOverride.orElse(query.getCatalog()));
            connection.setSchema(this.schemaOverride.orElse(query.getSchema()));
        }
        catch (SQLClientInfoException sQLClientInfoException) {
            // empty catch block
        }
    }

    private String createTemporaryTableName() {
        return this.rewritePrefix.getSuffix() + UUID.randomUUID().toString().replace("-", "");
    }

    private List<Column> getColumnsForTable(Connection connection, String catalog, String schema, String table) throws SQLException {
        ResultSet columns = connection.getMetaData().getColumns(catalog, QueryRewriter.escapeLikeExpression(connection, schema), QueryRewriter.escapeLikeExpression(connection, table), null);
        ImmutableList.Builder columnBuilder = new ImmutableList.Builder();
        while (columns.next()) {
            String name = columns.getString("COLUMN_NAME");
            int type = columns.getInt("DATA_TYPE");
            columnBuilder.add((Object)new Column(name, APPROXIMATE_TYPES.contains(type)));
        }
        return columnBuilder.build();
    }

    private List<Column> getColumns(Connection connection, CreateTableAsSelect createTableAsSelect) throws SQLException {
        com.facebook.presto.sql.tree.Query zeroRowsQuery;
        com.facebook.presto.sql.tree.Query createSelectClause = createTableAsSelect.getQuery();
        QueryBody innerQuery = createSelectClause.getQueryBody();
        if (innerQuery instanceof QuerySpecification) {
            QuerySpecification querySpecification = (QuerySpecification)innerQuery;
            innerQuery = new QuerySpecification(querySpecification.getSelect(), querySpecification.getFrom(), querySpecification.getWhere(), querySpecification.getGroupBy(), querySpecification.getHaving(), querySpecification.getOrderBy(), Optional.of("0"));
            zeroRowsQuery = new com.facebook.presto.sql.tree.Query(createSelectClause.getWith(), innerQuery, Optional.empty(), Optional.empty());
        } else {
            zeroRowsQuery = new com.facebook.presto.sql.tree.Query(createSelectClause.getWith(), innerQuery, Optional.empty(), Optional.of("0"));
        }
        ImmutableList.Builder columns = ImmutableList.builder();
        try (Statement jdbcStatement = connection.createStatement();){
            ExecutorService executor = Executors.newSingleThreadExecutor();
            SimpleTimeLimiter limiter = SimpleTimeLimiter.create((ExecutorService)executor);
            Statement limitedStatement = (Statement)limiter.newProxy((Object)jdbcStatement, Statement.class, this.timeout.toMillis(), TimeUnit.MILLISECONDS);
            try (ResultSet resultSet = limitedStatement.executeQuery(SqlFormatter.formatSql((Node)zeroRowsQuery, Optional.empty()));){
                ResultSetMetaData metaData = resultSet.getMetaData();
                for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                    String name = metaData.getColumnName(i);
                    int type = metaData.getColumnType(i);
                    columns.add((Object)new Column(name, APPROXIMATE_TYPES.contains(type)));
                }
            }
            catch (UncheckedTimeoutException e) {
                throw new SQLException("SQL statement execution timed out", e);
            }
            finally {
                executor.shutdownNow();
            }
        }
        return columns.build();
    }

    private String checksumSql(List<Column> columns, QualifiedName table) throws QueryRewriteException {
        if (columns.isEmpty()) {
            throw new QueryRewriteException("Table " + table + " has no columns", new Object[0]);
        }
        ImmutableList.Builder selectItems = ImmutableList.builder();
        for (Column column : columns) {
            Identifier expression = new Identifier(column.getName());
            if (column.isApproximateType()) {
                expression = new FunctionCall(QualifiedName.of((String)"round"), (List)ImmutableList.of((Object)expression, (Object)new LongLiteral(Integer.toString(this.doublePrecision))));
            }
            selectItems.add((Object)new SingleColumn((Expression)new FunctionCall(QualifiedName.of((String)"checksum"), (List)ImmutableList.of((Object)expression))));
        }
        Select select = new Select(false, (List)selectItems.build());
        return SqlFormatter.formatSql((Node)new QuerySpecification(select, Optional.of(new Table(table)), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty(), Optional.empty()), Optional.empty());
    }

    private static String dropTableSql(QualifiedName table) {
        return SqlFormatter.formatSql((Node)new DropTable(table, true), Optional.empty());
    }

    private static String escapeLikeExpression(Connection connection, String value) throws SQLException {
        String escapeString = connection.getMetaData().getSearchStringEscape();
        return value.replace(escapeString, escapeString + escapeString).replace("_", escapeString + "_").replace("%", escapeString + "%");
    }

    private static class Column {
        private final String name;
        private final boolean approximateType;

        private Column(String name, boolean approximateType) {
            this.name = name;
            this.approximateType = approximateType;
        }

        public String getName() {
            return this.name;
        }

        public boolean isApproximateType() {
            return this.approximateType;
        }
    }

    public static class QueryRewriteException
    extends Exception {
        public QueryRewriteException(String messageFormat, Object ... args) {
            super(String.format(messageFormat, args));
        }
    }
}

