/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier;

import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Objects;

public class QueryResult {
    private final State state;
    private final Exception exception;
    private final Duration wallTime;
    private final Duration cpuTime;
    private final String queryId;
    private final List<List<Object>> results;

    public QueryResult(State state, Exception exception, Duration wallTime, Duration cpuTime, String queryId, List<List<Object>> results) {
        this.state = Objects.requireNonNull(state, "state is null");
        this.exception = exception;
        this.wallTime = wallTime;
        this.cpuTime = cpuTime;
        this.queryId = queryId;
        this.results = results != null ? ImmutableList.copyOf(results) : null;
    }

    public State getState() {
        return this.state;
    }

    public Exception getException() {
        return this.exception;
    }

    public Duration getWallTime() {
        return this.wallTime;
    }

    public Duration getCpuTime() {
        return this.cpuTime;
    }

    public String getQueryId() {
        return this.queryId;
    }

    public List<List<Object>> getResults() {
        return this.results;
    }

    public void addSuppressed(Throwable throwable) {
        Preconditions.checkState((this.exception != null ? 1 : 0) != 0, (Object)"exception is null");
        Preconditions.checkArgument((throwable != null ? 1 : 0) != 0, (Object)"throwable is null");
        this.exception.addSuppressed(throwable);
    }

    public static enum State {
        INVALID,
        FAILED,
        SUCCESS,
        TOO_MANY_ROWS,
        TIMEOUT,
        FAILED_TO_SETUP,
        FAILED_TO_TEARDOWN;

    }
}

