/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier;

import com.facebook.presto.verifier.HumanReadableEventClient;
import com.facebook.presto.verifier.JsonEventClient;
import com.facebook.presto.verifier.SupportedEventClients;
import com.facebook.presto.verifier.VerifierConfig;
import com.facebook.presto.verifier.VerifierQueryEvent;
import com.google.inject.Binder;
import com.google.inject.Scopes;
import com.google.inject.multibindings.Multibinder;
import io.airlift.configuration.AbstractConfigurationAwareModule;
import io.airlift.configuration.ConfigBinder;
import io.airlift.event.client.EventBinder;
import io.airlift.event.client.EventClient;
import java.util.Set;

public class PrestoVerifierModule
extends AbstractConfigurationAwareModule {
    protected void setup(Binder binder) {
        ConfigBinder.configBinder((Binder)binder).bindConfig(VerifierConfig.class);
        EventBinder.eventBinder((Binder)binder).bindEventClient(new Class[]{VerifierQueryEvent.class});
        Multibinder supportedClients = Multibinder.newSetBinder((Binder)binder, String.class, SupportedEventClients.class);
        supportedClients.addBinding().toInstance((Object)"human-readable");
        supportedClients.addBinding().toInstance((Object)"file");
        Set<String> eventClientTypes = ((VerifierConfig)this.buildConfigObject(VerifierConfig.class)).getEventClients();
        PrestoVerifierModule.bindEventClientClasses(eventClientTypes, (Multibinder<EventClient>)Multibinder.newSetBinder((Binder)binder, EventClient.class));
    }

    private static void bindEventClientClasses(Set<String> eventClientTypes, Multibinder<EventClient> multibinder) {
        for (String eventClientType : eventClientTypes) {
            if (eventClientType.equals("human-readable")) {
                multibinder.addBinding().to(HumanReadableEventClient.class).in(Scopes.SINGLETON);
                continue;
            }
            if (!eventClientType.equals("file")) continue;
            multibinder.addBinding().to(JsonEventClient.class).in(Scopes.SINGLETON);
        }
    }
}

