/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier;

import com.facebook.presto.verifier.Query;
import com.facebook.presto.verifier.QueryPair;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import io.airlift.json.JsonCodec;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.util.List;
import java.util.Map;
import org.jdbi.v3.core.mapper.RowMapper;
import org.jdbi.v3.core.statement.StatementContext;

public class QueryPairMapper
implements RowMapper<QueryPair> {
    private static final JsonCodec<Map<String, String>> propertiesJsonCodec = JsonCodec.mapJsonCodec(String.class, String.class);
    private static final JsonCodec<List<String>> queriesJsonCodec = JsonCodec.listJsonCodec(String.class);

    public QueryPair map(ResultSet resultSet, StatementContext context) throws SQLException {
        Object sessionProperties = ImmutableMap.of();
        String json = resultSet.getString("session_properties_json");
        if (json != null) {
            sessionProperties = (Map)propertiesJsonCodec.fromJson(json);
        }
        return new QueryPair(resultSet.getString("suite"), resultSet.getString("name"), new Query(resultSet.getString("test_catalog"), resultSet.getString("test_schema"), QueryPairMapper.fromJsonString(resultSet.getString("test_prequeries")), resultSet.getString("test_query"), QueryPairMapper.fromJsonString(resultSet.getString("test_postqueries")), resultSet.getString("test_username"), resultSet.getString("test_password"), (Map<String, String>)sessionProperties), new Query(resultSet.getString("control_catalog"), resultSet.getString("control_schema"), QueryPairMapper.fromJsonString(resultSet.getString("control_prequeries")), resultSet.getString("control_query"), QueryPairMapper.fromJsonString(resultSet.getString("control_postqueries")), resultSet.getString("control_username"), resultSet.getString("control_password"), (Map<String, String>)sessionProperties));
    }

    private static List<String> fromJsonString(String jsonString) {
        return jsonString == null ? ImmutableList.of() : (List)queriesJsonCodec.fromJson(jsonString);
    }
}

