/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier;

import com.facebook.presto.jdbc.QueryStats;
import com.facebook.presto.spi.type.SqlVarbinary;
import com.facebook.presto.verifier.Query;
import com.facebook.presto.verifier.QueryPair;
import com.facebook.presto.verifier.QueryResult;
import com.facebook.presto.verifier.TypesDoNotMatchException;
import com.facebook.presto.verifier.VerifierException;
import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Strings;
import com.google.common.collect.ComparisonChain;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSortedMultiset;
import com.google.common.collect.Iterables;
import com.google.common.collect.Multiset;
import com.google.common.collect.Multisets;
import com.google.common.collect.Ordering;
import com.google.common.primitives.Doubles;
import io.airlift.units.Duration;
import java.math.BigDecimal;
import java.math.MathContext;
import java.sql.Array;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLClientInfoException;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.concurrent.Callable;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Function;

public class Validator {
    private final String testUsername;
    private final String controlUsername;
    private final String testPassword;
    private final String controlPassword;
    private final String controlGateway;
    private final String testGateway;
    private final Duration controlTimeout;
    private final Duration testTimeout;
    private final int maxRowCount;
    private final boolean checkCorrectness;
    private final boolean checkDeterministic;
    private final boolean verboseResultsComparison;
    private final QueryPair queryPair;
    private final boolean explainOnly;
    private final Map<String, String> sessionProperties;
    private final int precision;
    private final int controlTeardownRetries;
    private final int testTeardownRetries;
    private Boolean valid;
    private QueryResult controlResult;
    private QueryResult testResult;
    private final List<QueryResult> controlPreQueryResults = new ArrayList<QueryResult>();
    private final List<QueryResult> controlPostQueryResults = new ArrayList<QueryResult>();
    private final List<QueryResult> testPreQueryResults = new ArrayList<QueryResult>();
    private final List<QueryResult> testPostQueryResults = new ArrayList<QueryResult>();
    private boolean deterministic = true;

    public Validator(String controlGateway, String testGateway, Duration controlTimeout, Duration testTimeout, int maxRowCount, boolean explainOnly, int precision, boolean checkCorrectness, boolean checkDeterministic, boolean verboseResultsComparison, int controlTeardownRetries, int testTeardownRetries, QueryPair queryPair) {
        this.testUsername = Objects.requireNonNull(queryPair.getTest().getUsername(), "test username is null");
        this.controlUsername = Objects.requireNonNull(queryPair.getControl().getUsername(), "control username is null");
        this.testPassword = queryPair.getTest().getPassword();
        this.controlPassword = queryPair.getControl().getPassword();
        this.controlGateway = Objects.requireNonNull(controlGateway, "controlGateway is null");
        this.testGateway = Objects.requireNonNull(testGateway, "testGateway is null");
        this.controlTimeout = controlTimeout;
        this.testTimeout = testTimeout;
        this.maxRowCount = maxRowCount;
        this.explainOnly = explainOnly;
        this.precision = precision;
        this.checkCorrectness = checkCorrectness;
        this.checkDeterministic = checkDeterministic;
        this.verboseResultsComparison = verboseResultsComparison;
        this.controlTeardownRetries = controlTeardownRetries;
        this.testTeardownRetries = testTeardownRetries;
        this.queryPair = Objects.requireNonNull(queryPair, "queryPair is null");
        this.sessionProperties = queryPair.getTest().getSessionProperties();
    }

    public boolean isSkipped() {
        if (this.queryPair.getControl().getQuery().isEmpty() || this.queryPair.getTest().getQuery().isEmpty()) {
            return true;
        }
        if (this.getControlResult().getState() != QueryResult.State.SUCCESS) {
            return true;
        }
        if (!this.isDeterministic()) {
            return true;
        }
        return this.getTestResult().getState() == QueryResult.State.TIMEOUT;
    }

    public String getSkippedMessage() {
        StringBuilder sb = new StringBuilder();
        if (this.getControlResult().getState() == QueryResult.State.TOO_MANY_ROWS) {
            sb.append("----------\n");
            sb.append("Name: " + this.queryPair.getName() + "\n");
            sb.append("Schema (control): " + this.queryPair.getControl().getSchema() + "\n");
            sb.append("Too many rows.\n");
        } else if (!this.isDeterministic()) {
            sb.append("----------\n");
            sb.append("Name: " + this.queryPair.getName() + "\n");
            sb.append("Schema (control): " + this.queryPair.getControl().getSchema() + "\n");
            sb.append("NON DETERMINISTIC\n");
        } else if (this.getControlResult().getState() == QueryResult.State.TIMEOUT || this.getTestResult().getState() == QueryResult.State.TIMEOUT) {
            sb.append("----------\n");
            sb.append("Name: " + this.queryPair.getName() + "\n");
            sb.append("Schema (control): " + this.queryPair.getControl().getSchema() + "\n");
            sb.append("TIMEOUT\n");
        } else {
            sb.append("SKIPPED: ");
            if (this.getControlResult().getException() != null) {
                sb.append(this.getControlResult().getException().getMessage());
            }
        }
        return sb.toString();
    }

    public boolean valid() {
        if (this.valid == null) {
            this.valid = this.validate();
        }
        return this.valid;
    }

    public boolean isDeterministic() {
        if (this.valid == null) {
            this.valid = this.validate();
        }
        return this.deterministic;
    }

    private boolean validate() {
        this.controlResult = this.executeQueryControl();
        if (this.controlResult.getState() == QueryResult.State.TOO_MANY_ROWS) {
            this.testResult = new QueryResult(QueryResult.State.INVALID, null, null, null, null, (List<List<Object>>)ImmutableList.of());
            return false;
        }
        if (this.controlResult.getState() != QueryResult.State.SUCCESS) {
            this.testResult = new QueryResult(QueryResult.State.INVALID, null, null, null, null, (List<List<Object>>)ImmutableList.of());
            return true;
        }
        this.testResult = this.executeQueryTest();
        if (this.controlResult.getState() != QueryResult.State.SUCCESS || this.testResult.getState() != QueryResult.State.SUCCESS) {
            return false;
        }
        if (!this.checkCorrectness) {
            return true;
        }
        boolean matches = Validator.resultsMatch(this.controlResult, this.testResult, this.precision);
        if (!matches && this.checkDeterministic) {
            return this.checkForDeterministicAndRerunTestQueriesIfNeeded();
        }
        return matches;
    }

    private static QueryResult tearDown(Query query, List<QueryResult> postQueryResults, Function<String, QueryResult> executor) {
        postQueryResults.clear();
        for (String postqueryString : query.getPostQueries()) {
            QueryResult queryResult = executor.apply(postqueryString);
            postQueryResults.add(queryResult);
            if (queryResult.getState() == QueryResult.State.SUCCESS) continue;
            return new QueryResult(QueryResult.State.FAILED_TO_TEARDOWN, queryResult.getException(), queryResult.getWallTime(), queryResult.getCpuTime(), queryResult.getQueryId(), (List<List<Object>>)ImmutableList.of());
        }
        return new QueryResult(QueryResult.State.SUCCESS, null, null, null, null, (List<List<Object>>)ImmutableList.of());
    }

    private static QueryResult setup(Query query, List<QueryResult> preQueryResults, Function<String, QueryResult> executor) {
        preQueryResults.clear();
        for (String prequeryString : query.getPreQueries()) {
            QueryResult queryResult = executor.apply(prequeryString);
            preQueryResults.add(queryResult);
            if (queryResult.getState() == QueryResult.State.SUCCESS) continue;
            return new QueryResult(QueryResult.State.FAILED_TO_SETUP, queryResult.getException(), queryResult.getWallTime(), queryResult.getCpuTime(), queryResult.getQueryId(), (List<List<Object>>)ImmutableList.of());
        }
        return new QueryResult(QueryResult.State.SUCCESS, null, null, null, null, (List<List<Object>>)ImmutableList.of());
    }

    private boolean checkForDeterministicAndRerunTestQueriesIfNeeded() {
        int i;
        for (i = 0; i < 3; ++i) {
            QueryResult results = this.executeQueryControl();
            if (results.getState() != QueryResult.State.SUCCESS) {
                return false;
            }
            if (Validator.resultsMatch(this.controlResult, results, this.precision)) continue;
            this.deterministic = false;
            return false;
        }
        for (i = 0; i < 3; ++i) {
            this.testResult = this.executeQueryTest();
            if (this.testResult.getState() != QueryResult.State.SUCCESS) {
                return false;
            }
            if (Validator.resultsMatch(this.controlResult, this.testResult, this.precision)) continue;
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryResult executeQueryTest() {
        QueryResult tearDownResult;
        int retry;
        Query query = this.queryPair.getTest();
        QueryResult queryResult = new QueryResult(QueryResult.State.INVALID, null, null, null, null, (List<List<Object>>)ImmutableList.of());
        try {
            queryResult = Validator.setup(query, this.testPreQueryResults, testPrequery -> this.executeQuery(this.testGateway, this.testUsername, this.testPassword, this.queryPair.getTest(), (String)testPrequery, this.testTimeout, this.sessionProperties));
            if (queryResult.getState() == QueryResult.State.SUCCESS) {
                queryResult = this.executeQuery(this.testGateway, this.testUsername, this.testPassword, this.queryPair.getTest(), query.getQuery(), this.testTimeout, this.sessionProperties);
            }
            retry = 0;
        }
        catch (Throwable throwable) {
            QueryResult tearDownResult2;
            int retry2 = 0;
            while ((tearDownResult2 = Validator.tearDown(query, this.testPostQueryResults, testPostquery -> this.executeQuery(this.testGateway, this.testUsername, this.testPassword, this.queryPair.getTest(), (String)testPostquery, this.testTimeout, this.sessionProperties))).getState() != QueryResult.State.SUCCESS) {
                try {
                    TimeUnit.MINUTES.sleep(1L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                if (++retry2 < this.testTeardownRetries) continue;
            }
            queryResult = tearDownResult2.getState() == QueryResult.State.SUCCESS ? queryResult : tearDownResult2;
            throw throwable;
        }
        while ((tearDownResult = Validator.tearDown(query, this.testPostQueryResults, testPostquery -> this.executeQuery(this.testGateway, this.testUsername, this.testPassword, this.queryPair.getTest(), (String)testPostquery, this.testTimeout, this.sessionProperties))).getState() != QueryResult.State.SUCCESS) {
            try {
                TimeUnit.MINUTES.sleep(1L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            if (++retry < this.testTeardownRetries) continue;
        }
        queryResult = tearDownResult.getState() == QueryResult.State.SUCCESS ? queryResult : tearDownResult;
        return queryResult;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private QueryResult executeQueryControl() {
        QueryResult tearDownResult;
        int retry;
        Query query = this.queryPair.getControl();
        QueryResult queryResult = new QueryResult(QueryResult.State.INVALID, null, null, null, null, (List<List<Object>>)ImmutableList.of());
        try {
            queryResult = Validator.setup(query, this.controlPreQueryResults, controlPrequery -> this.executeQuery(this.controlGateway, this.controlUsername, this.controlPassword, this.queryPair.getControl(), (String)controlPrequery, this.controlTimeout, this.sessionProperties));
            if (queryResult.getState() == QueryResult.State.SUCCESS) {
                queryResult = this.executeQuery(this.controlGateway, this.controlUsername, this.controlPassword, this.queryPair.getControl(), query.getQuery(), this.controlTimeout, this.sessionProperties);
            }
            retry = 0;
        }
        catch (Throwable throwable) {
            QueryResult tearDownResult2;
            int retry2 = 0;
            while ((tearDownResult2 = Validator.tearDown(query, this.controlPostQueryResults, controlPostquery -> this.executeQuery(this.controlGateway, this.controlUsername, this.controlPassword, this.queryPair.getControl(), (String)controlPostquery, this.controlTimeout, this.sessionProperties))).getState() != QueryResult.State.SUCCESS) {
                try {
                    TimeUnit.MINUTES.sleep(1L);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                    break;
                }
                if (++retry2 < this.controlTeardownRetries) continue;
            }
            queryResult = tearDownResult2.getState() == QueryResult.State.SUCCESS ? queryResult : tearDownResult2;
            throw throwable;
        }
        while ((tearDownResult = Validator.tearDown(query, this.controlPostQueryResults, controlPostquery -> this.executeQuery(this.controlGateway, this.controlUsername, this.controlPassword, this.queryPair.getControl(), (String)controlPostquery, this.controlTimeout, this.sessionProperties))).getState() != QueryResult.State.SUCCESS) {
            try {
                TimeUnit.MINUTES.sleep(1L);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
            if (++retry < this.controlTeardownRetries) continue;
        }
        queryResult = tearDownResult.getState() == QueryResult.State.SUCCESS ? queryResult : tearDownResult;
        return queryResult;
    }

    public QueryPair getQueryPair() {
        return this.queryPair;
    }

    public QueryResult getControlResult() {
        return this.controlResult;
    }

    public QueryResult getTestResult() {
        return this.testResult;
    }

    public List<QueryResult> getControlPreQueryResults() {
        return this.controlPreQueryResults;
    }

    public List<QueryResult> getControlPostQueryResults() {
        return this.controlPostQueryResults;
    }

    public List<QueryResult> getTestPreQueryResults() {
        return this.testPreQueryResults;
    }

    public List<QueryResult> getTestPostQueryResults() {
        return this.testPostQueryResults;
    }

    /*
     * Exception decompiling
     */
    private QueryResult executeQuery(String url, String username, String password, Query query, String sql, Duration timeout, Map<String, String> sessionProperties) {
        /*
         * This method has failed to decompile.  When submitting a bug report, please provide this stack trace, and (if you hold appropriate legal rights) the relevant class file.
         * 
         * org.benf.cfr.reader.util.ConfusedCFRException: Tried to end blocks [25[CATCHBLOCK]], but top level block is 13[TRYBLOCK]
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.processEndingBlocks(Op04StructuredStatement.java:435)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op04StructuredStatement.buildNestedBlocks(Op04StructuredStatement.java:484)
         *     at org.benf.cfr.reader.bytecode.analysis.opgraph.Op03SimpleStatement.createInitialStructuredBlock(Op03SimpleStatement.java:736)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisInner(CodeAnalyser.java:850)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysisOrWrapFail(CodeAnalyser.java:278)
         *     at org.benf.cfr.reader.bytecode.CodeAnalyser.getAnalysis(CodeAnalyser.java:201)
         *     at org.benf.cfr.reader.entities.attributes.AttributeCode.analyse(AttributeCode.java:94)
         *     at org.benf.cfr.reader.entities.Method.analyse(Method.java:531)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseMid(ClassFile.java:1055)
         *     at org.benf.cfr.reader.entities.ClassFile.analyseTop(ClassFile.java:942)
         *     at org.benf.cfr.reader.Driver.doJarVersionTypes(Driver.java:257)
         *     at org.benf.cfr.reader.Driver.doJar(Driver.java:139)
         *     at org.benf.cfr.reader.CfrDriverImpl.analyse(CfrDriverImpl.java:76)
         *     at org.benf.cfr.reader.Main.main(Main.java:54)
         */
        throw new IllegalStateException("Decompilation failed");
    }

    private void trySetConnectionProperties(Query query, Connection connection) throws SQLException {
        try {
            connection.setClientInfo("ApplicationName", "verifier-test:" + this.queryPair.getName());
            connection.setCatalog(query.getCatalog());
            connection.setSchema(query.getSchema());
        }
        catch (SQLClientInfoException sQLClientInfoException) {
            // empty catch block
        }
    }

    private Callable<List<List<Object>>> getResultSetConverter(ResultSet resultSet) {
        return () -> this.convertJdbcResultSet(resultSet);
    }

    private static boolean isPrestoQueryInvalid(SQLException e) {
        for (Throwable t = e.getCause(); t != null; t = t.getCause()) {
            if (t.toString().contains(".SemanticException:")) {
                return true;
            }
            if (t.toString().contains(".ParsingException:")) {
                return true;
            }
            if (!Strings.nullToEmpty((String)t.getMessage()).matches("Function .* not registered")) continue;
            return true;
        }
        return false;
    }

    private List<List<Object>> convertJdbcResultSet(ResultSet resultSet) throws SQLException, VerifierException {
        int rowCount = 0;
        int columnCount = resultSet.getMetaData().getColumnCount();
        ImmutableList.Builder rows = ImmutableList.builder();
        while (resultSet.next()) {
            ArrayList<Object> row = new ArrayList<Object>();
            for (int i = 1; i <= columnCount; ++i) {
                Object object = resultSet.getObject(i);
                if (object instanceof BigDecimal) {
                    object = ((BigDecimal)object).scale() <= 0 ? (Number)((BigDecimal)object).longValueExact() : (Number)((BigDecimal)object).doubleValue();
                }
                if (object instanceof Array) {
                    object = ((Array)object).getArray();
                }
                if (object instanceof byte[]) {
                    object = new SqlVarbinary((byte[])object);
                }
                row.add(object);
            }
            rows.add(Collections.unmodifiableList(row));
            if (++rowCount <= this.maxRowCount) continue;
            throw new VerifierException("More than '" + this.maxRowCount + "' rows, failing query");
        }
        return rows.build();
    }

    private static boolean resultsMatch(QueryResult controlResult, QueryResult testResult, int precision) {
        ImmutableSortedMultiset control = ImmutableSortedMultiset.copyOf(Validator.rowComparator(precision), controlResult.getResults());
        ImmutableSortedMultiset test = ImmutableSortedMultiset.copyOf(Validator.rowComparator(precision), testResult.getResults());
        try {
            return control.equals(test);
        }
        catch (TypesDoNotMatchException e) {
            return false;
        }
    }

    public String getResultsComparison(int precision) {
        List<List<Object>> controlResults = this.controlResult.getResults();
        List<List<Object>> testResults = this.testResult.getResults();
        if (this.valid() || controlResults == null || testResults == null) {
            return "";
        }
        ImmutableSortedMultiset control = ImmutableSortedMultiset.copyOf(Validator.rowComparator(precision), controlResults);
        ImmutableSortedMultiset test = ImmutableSortedMultiset.copyOf(Validator.rowComparator(precision), testResults);
        try {
            Object diff = ImmutableSortedMultiset.naturalOrder().addAll(Iterables.transform((Iterable)Multisets.difference((Multiset)control, (Multiset)test), row -> new ChangedRow(ChangedRow.Changed.REMOVED, (List)row, precision))).addAll(Iterables.transform((Iterable)Multisets.difference((Multiset)test, (Multiset)control), row -> new ChangedRow(ChangedRow.Changed.ADDED, (List)row, precision))).build();
            diff = Iterables.limit((Iterable)diff, (int)100);
            StringBuilder sb = new StringBuilder();
            sb.append(String.format("Control %s rows, Test %s rows%n", control.size(), test.size()));
            if (this.verboseResultsComparison) {
                Joiner.on((String)"\n").appendTo(sb, (Iterable)diff);
            } else {
                sb.append("RESULTS DO NOT MATCH\n");
            }
            return sb.toString();
        }
        catch (TypesDoNotMatchException e) {
            return e.getMessage();
        }
    }

    private static Comparator<List<Object>> rowComparator(int precision) {
        Ordering comparator = Ordering.from(Validator.columnComparator(precision)).nullsFirst();
        return (arg_0, arg_1) -> Validator.lambda$rowComparator$7((Comparator)comparator, arg_0, arg_1);
    }

    private static Comparator<Object> columnComparator(int precision) {
        return (a, b) -> {
            if (a == null || b == null) {
                if (a == null && b == null) {
                    return 0;
                }
                return a == null ? -1 : 1;
            }
            if (a instanceof Number && b instanceof Number) {
                boolean bothIntegral;
                Number x = (Number)a;
                Number y = (Number)b;
                boolean bothReal = Validator.isReal(x) && Validator.isReal(y);
                boolean bl = bothIntegral = Validator.isIntegral(x) && Validator.isIntegral(y);
                if (!bothReal && !bothIntegral) {
                    throw new TypesDoNotMatchException(String.format("item types do not match: %s vs %s", a.getClass().getName(), b.getClass().getName()));
                }
                if (Validator.isIntegral(x)) {
                    return Long.compare(x.longValue(), y.longValue());
                }
                return Validator.precisionCompare(x.doubleValue(), y.doubleValue(), precision);
            }
            if (a.getClass() != b.getClass()) {
                throw new TypesDoNotMatchException(String.format("item types do not match: %s vs %s", a.getClass().getName(), b.getClass().getName()));
            }
            if (a.getClass().isArray() && b.getClass().isArray()) {
                Object[] aArray = (Object[])a;
                Object[] bArray = (Object[])b;
                if (aArray.length != bArray.length) {
                    return Arrays.hashCode((Object[])a) < Arrays.hashCode((Object[])b) ? -1 : 1;
                }
                for (int i = 0; i < aArray.length; ++i) {
                    int compareResult = Validator.columnComparator(precision).compare(aArray[i], bArray[i]);
                    if (compareResult == 0) continue;
                    return compareResult;
                }
                return 0;
            }
            if (a instanceof List && b instanceof List) {
                List aList = (List)a;
                List bList = (List)b;
                if (aList.size() != bList.size()) {
                    return a.hashCode() < b.hashCode() ? -1 : 1;
                }
                for (int i = 0; i < aList.size(); ++i) {
                    int compareResult = Validator.columnComparator(precision).compare(aList.get(i), bList.get(i));
                    if (compareResult == 0) continue;
                    return compareResult;
                }
                return 0;
            }
            if (a instanceof Map && b instanceof Map) {
                Map aMap = (Map)a;
                Map bMap = (Map)b;
                if (aMap.size() != bMap.size()) {
                    return a.hashCode() < b.hashCode() ? -1 : 1;
                }
                for (Object aKey : aMap.keySet()) {
                    boolean foundMatchingKey = false;
                    for (Object bKey : bMap.keySet()) {
                        if (Validator.columnComparator(precision).compare(aKey, bKey) != 0) continue;
                        int compareResult = Validator.columnComparator(precision).compare(aMap.get(aKey), bMap.get(bKey));
                        if (compareResult != 0) {
                            return compareResult;
                        }
                        foundMatchingKey = true;
                    }
                    if (foundMatchingKey) continue;
                    return a.hashCode() < b.hashCode() ? -1 : 1;
                }
                return 0;
            }
            Preconditions.checkArgument((boolean)(a instanceof Comparable), (String)"item is not Comparable: %s", (Object[])new Object[]{a.getClass().getName()});
            return ((Comparable)a).compareTo(b);
        };
    }

    private static boolean isReal(Number x) {
        return x instanceof Float || x instanceof Double;
    }

    private static boolean isIntegral(Number x) {
        return x instanceof Byte || x instanceof Short || x instanceof Integer || x instanceof Long;
    }

    private static int precisionCompare(double a, double b, int precision) {
        if (!Doubles.isFinite((double)a) || !Doubles.isFinite((double)b)) {
            return Double.compare(a, b);
        }
        MathContext context = new MathContext(precision);
        BigDecimal x = new BigDecimal(a).round(context);
        BigDecimal y = new BigDecimal(b).round(context);
        return x.compareTo(y);
    }

    private static /* synthetic */ int lambda$rowComparator$7(Comparator comparator, List a, List b) {
        if (a.size() != b.size()) {
            return Integer.compare(a.size(), b.size());
        }
        for (int i = 0; i < a.size(); ++i) {
            int r = comparator.compare(a.get(i), b.get(i));
            if (r == 0) continue;
            return r;
        }
        return 0;
    }

    private static class ProgressMonitor
    implements Consumer<QueryStats> {
        private QueryStats queryStats;
        private boolean finished = false;

        private ProgressMonitor() {
        }

        @Override
        public synchronized void accept(QueryStats queryStats) {
            Preconditions.checkState((!this.finished ? 1 : 0) != 0);
            this.queryStats = queryStats;
        }

        public synchronized QueryStats getFinalQueryStats() {
            this.finished = true;
            return this.queryStats;
        }
    }

    public static class ChangedRow
    implements Comparable<ChangedRow> {
        private final Changed changed;
        private final List<Object> row;
        private final int precision;

        private ChangedRow(Changed changed, List<Object> row, int precision) {
            this.changed = changed;
            this.row = row;
            this.precision = precision;
        }

        public String toString() {
            if (this.changed == Changed.ADDED) {
                return "+ " + this.row;
            }
            return "- " + this.row;
        }

        @Override
        public int compareTo(ChangedRow that) {
            return ComparisonChain.start().compare(this.row, that.row, Validator.rowComparator(this.precision)).compareFalseFirst(this.changed == Changed.ADDED, that.changed == Changed.ADDED).result();
        }

        public static enum Changed {
            ADDED,
            REMOVED;

        }
    }
}

