/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier;

import com.facebook.presto.util.Types;
import com.facebook.presto.verifier.VerifierConfig;
import com.facebook.presto.verifier.VerifierQueryEvent;
import io.airlift.event.client.AbstractEventClient;
import io.airlift.stats.QuantileDigest;
import io.airlift.units.Duration;
import java.io.Closeable;
import java.io.IOException;
import java.util.Optional;
import java.util.concurrent.TimeUnit;
import javax.inject.Inject;

public class HumanReadableEventClient
extends AbstractEventClient
implements Closeable {
    private static final double LARGE_SPEEDUP = 0.5;
    private static final double SMALL_SPEEDUP = 1.0;
    private static final double SMALL_REGRESSION = 2.0;
    private final boolean alwaysPrint;
    private final QuantileDigest cpuRatioAll = new QuantileDigest(0.01);
    private final QuantileDigest cpuRatioLargeSpeedup = new QuantileDigest(0.01);
    private final QuantileDigest cpuRatioSmallSpeedup = new QuantileDigest(0.01);
    private final QuantileDigest cpuRatioSmallRegression = new QuantileDigest(0.01);
    private final QuantileDigest cpuRatioLargeRegression = new QuantileDigest(0.01);
    private final Duration regressionMinCpuTime;

    @Inject
    public HumanReadableEventClient(VerifierConfig config) {
        this.alwaysPrint = config.isAlwaysReport();
        this.regressionMinCpuTime = config.getRegressionMinCpuTime();
    }

    public <T> void postEvent(T event) throws IOException {
        VerifierQueryEvent queryEvent = (VerifierQueryEvent)Types.checkType(event, VerifierQueryEvent.class, (String)"event");
        Optional<Double> cpuRatio = this.getCpuRatio(queryEvent);
        if (cpuRatio.isPresent()) {
            this.recordCpuRatio(cpuRatio.get());
        }
        if (this.alwaysPrint || queryEvent.isFailed() || cpuRatio.map(ratio -> ratio > 2.0).orElse(false).booleanValue()) {
            this.printEvent(queryEvent);
        }
    }

    private void recordCpuRatio(double cpuRatio) {
        if (cpuRatio <= 0.5) {
            this.cpuRatioLargeSpeedup.add(HumanReadableEventClient.doubleToSortableLong(cpuRatio));
        } else if (cpuRatio <= 1.0) {
            this.cpuRatioSmallSpeedup.add(HumanReadableEventClient.doubleToSortableLong(cpuRatio));
        } else if (cpuRatio <= 2.0) {
            this.cpuRatioSmallRegression.add(HumanReadableEventClient.doubleToSortableLong(cpuRatio));
        } else {
            this.cpuRatioLargeRegression.add(HumanReadableEventClient.doubleToSortableLong(cpuRatio));
        }
        this.cpuRatioAll.add(HumanReadableEventClient.doubleToSortableLong(cpuRatio));
    }

    @Override
    public void close() {
        long totalCount = (long)this.cpuRatioAll.getCount();
        StringBuilder builder = new StringBuilder();
        builder.append("\n");
        builder.append("CPU Ratio\n");
        builder.append("Bucket      (p50)  count      (%)\n");
        builder.append("---------------------------------\n");
        builder.append(HumanReadableEventClient.formatBucket(0.0, 0.5, this.cpuRatioLargeSpeedup, totalCount) + "\n");
        builder.append(HumanReadableEventClient.formatBucket(0.5, 1.0, this.cpuRatioSmallSpeedup, totalCount) + "\n");
        builder.append(HumanReadableEventClient.formatBucket(1.0, 2.0, this.cpuRatioSmallRegression, totalCount) + "\n");
        builder.append(HumanReadableEventClient.formatBucket(2.0, Double.POSITIVE_INFINITY, this.cpuRatioLargeRegression, totalCount) + "\n");
        builder.append("\n");
        builder.append("CPU Ratio Distribution\n");
        builder.append("-----------------------\n");
        builder.append(String.format("count: %s\n", this.cpuRatioAll.getCount()));
        builder.append(String.format("min: %3.1f\n", 100.0 * HumanReadableEventClient.sortableLongToDouble(this.cpuRatioAll.getMin())));
        builder.append(String.format("p01: %3.1f\n", 100.0 * HumanReadableEventClient.sortableLongToDouble(this.cpuRatioAll.getQuantile(0.01))));
        builder.append(String.format("p05: %3.1f\n", 100.0 * HumanReadableEventClient.sortableLongToDouble(this.cpuRatioAll.getQuantile(0.05))));
        builder.append(String.format("p10: %3.1f\n", 100.0 * HumanReadableEventClient.sortableLongToDouble(this.cpuRatioAll.getQuantile(0.1))));
        builder.append(String.format("p25: %3.1f\n", 100.0 * HumanReadableEventClient.sortableLongToDouble(this.cpuRatioAll.getQuantile(0.25))));
        builder.append(String.format("p50: %3.1f\n", 100.0 * HumanReadableEventClient.sortableLongToDouble(this.cpuRatioAll.getQuantile(0.5))));
        builder.append(String.format("p75: %3.1f\n", 100.0 * HumanReadableEventClient.sortableLongToDouble(this.cpuRatioAll.getQuantile(0.75))));
        builder.append(String.format("p90: %3.1f\n", 100.0 * HumanReadableEventClient.sortableLongToDouble(this.cpuRatioAll.getQuantile(0.9))));
        builder.append(String.format("p99: %3.1f\n", 100.0 * HumanReadableEventClient.sortableLongToDouble(this.cpuRatioAll.getQuantile(0.99))));
        builder.append(String.format("max: %3.1f\n", 100.0 * HumanReadableEventClient.sortableLongToDouble(this.cpuRatioAll.getMax())));
        System.out.println(builder);
    }

    public static String formatBucket(double min, double max, QuantileDigest digest, long totalCount) {
        double p50 = HumanReadableEventClient.sortableLongToDouble(digest.getQuantile(0.5));
        long count = (long)digest.getCount();
        double countRatio = 1.0 * (double)count / (double)totalCount;
        String maxValue = max == Double.POSITIVE_INFINITY ? "inf" : String.format("%3.1f", max);
        return String.format("%3.1f - %s  (%4.2f) %6d  (%4.1f%%)", min, maxValue, p50, count, countRatio * 100.0);
    }

    private void printEvent(VerifierQueryEvent queryEvent) {
        System.out.println("----------");
        System.out.println("Name: " + queryEvent.getName());
        System.out.println("Schema (control): " + queryEvent.getControlSchema());
        System.out.println("Schema (test): " + queryEvent.getTestSchema());
        System.out.println("Valid: " + !queryEvent.isFailed());
        System.out.println("Query (test): " + queryEvent.getTestQuery());
        if (queryEvent.isFailed()) {
            System.out.println("\nError message:\n" + queryEvent.getErrorMessage());
        } else {
            System.out.println("Control Duration (secs): " + queryEvent.getControlWallTimeSecs());
            System.out.println("   Test Duration (secs): " + queryEvent.getTestWallTimeSecs());
            Optional<Double> cpuRatio = this.getCpuRatio(queryEvent);
            if (cpuRatio.isPresent()) {
                System.out.println("Control CPU (secs): " + queryEvent.getControlCpuTimeSecs());
                System.out.println("   Test CPU (secs): " + queryEvent.getTestCpuTimeSecs());
                System.out.println(String.format("         CPU Ratio: %.1f\n", (double)cpuRatio.get()));
            }
        }
        System.out.println("----------");
    }

    private Optional<Double> getCpuRatio(VerifierQueryEvent queryEvent) {
        Double controlCpuTime = queryEvent.getControlCpuTimeSecs();
        Double testCpuTime = queryEvent.getTestCpuTimeSecs();
        if (controlCpuTime == null || testCpuTime == null) {
            return Optional.empty();
        }
        if (controlCpuTime < this.regressionMinCpuTime.getValue(TimeUnit.SECONDS)) {
            return Optional.empty();
        }
        double value = testCpuTime / controlCpuTime;
        if (Double.isNaN(value)) {
            value = 1.0;
        }
        return Optional.of(value);
    }

    private static double sortableLongToDouble(long value) {
        value ^= value >> 63 & Long.MAX_VALUE;
        return Double.longBitsToDouble(value);
    }

    private static long doubleToSortableLong(double value) {
        long bits = Double.doubleToRawLongBits(value);
        return bits ^ bits >> 63 & Long.MAX_VALUE;
    }
}

