/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier;

import com.google.common.collect.ImmutableList;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Objects;

public class QueryResult {
    private final State state;
    private final Exception exception;
    private final Duration wallTime;
    private final Duration cpuTime;
    private final List<List<Object>> results;

    public QueryResult(State state, Exception exception, Duration wallTime, Duration cpuTime, List<List<Object>> results) {
        this.state = Objects.requireNonNull(state, "state is null");
        this.exception = exception;
        this.wallTime = wallTime;
        this.cpuTime = cpuTime;
        this.results = results != null ? ImmutableList.copyOf(results) : null;
    }

    public State getState() {
        return this.state;
    }

    public Exception getException() {
        return this.exception;
    }

    public Duration getWallTime() {
        return this.wallTime;
    }

    public Duration getCpuTime() {
        return this.cpuTime;
    }

    public List<List<Object>> getResults() {
        return this.results;
    }

    public static enum State {
        INVALID,
        FAILED,
        SUCCESS,
        TOO_MANY_ROWS,
        TIMEOUT,
        FAILED_TO_SETUP,
        FAILED_TO_TEARDOWN;

    }
}

