/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier;

import com.facebook.presto.util.ImmutableCollectors;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;

public class Query {
    private final String catalog;
    private final String schema;
    private final List<String> preQueries;
    private final String query;
    private final List<String> postQueries;
    private final String username;
    private final String password;
    private final Map<String, String> sessionProperties;

    @JsonCreator
    public Query(@JsonProperty(value="catalog") String catalog, @JsonProperty(value="schema") String schema, @JsonProperty(value="preQueries") List<String> preQueries, @JsonProperty(value="query") String query, @JsonProperty(value="postQueries") List<String> postQueries, @JsonProperty(value="username") String username, @JsonProperty(value="password") String password, @JsonProperty(value="sessionProperties") Map<String, String> sessionProperties) {
        this.catalog = catalog;
        this.schema = schema;
        this.preQueries = (List)preQueries.stream().map(Query::clean).collect(ImmutableCollectors.toImmutableList());
        this.query = Query.clean(query);
        this.postQueries = (List)postQueries.stream().map(Query::clean).collect(ImmutableCollectors.toImmutableList());
        this.username = username;
        this.password = password;
        this.sessionProperties = ImmutableMap.copyOf(sessionProperties);
    }

    @JsonProperty
    public String getCatalog() {
        return this.catalog;
    }

    @JsonProperty
    public String getSchema() {
        return this.schema;
    }

    @JsonProperty
    public List<String> getPreQueries() {
        return this.preQueries;
    }

    @JsonProperty
    public String getQuery() {
        return this.query;
    }

    @JsonProperty
    public List<String> getPostQueries() {
        return this.postQueries;
    }

    @JsonProperty
    public String getUsername() {
        return this.username;
    }

    @JsonProperty
    public String getPassword() {
        return this.password;
    }

    @JsonProperty
    public Map<String, String> getSessionProperties() {
        return this.sessionProperties;
    }

    private static String clean(String sql) {
        sql = sql.replaceAll("\t", "  ");
        sql = sql.replaceAll("\n+", "\n");
        sql = sql.trim();
        while (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1).trim();
        }
        return sql;
    }
}

