/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier;

import com.facebook.presto.sql.parser.SqlParser;
import com.facebook.presto.sql.parser.SqlParserOptions;
import com.facebook.presto.sql.tree.AddColumn;
import com.facebook.presto.sql.tree.CreateTable;
import com.facebook.presto.sql.tree.CreateTableAsSelect;
import com.facebook.presto.sql.tree.CreateView;
import com.facebook.presto.sql.tree.Delete;
import com.facebook.presto.sql.tree.DropTable;
import com.facebook.presto.sql.tree.DropView;
import com.facebook.presto.sql.tree.Explain;
import com.facebook.presto.sql.tree.Insert;
import com.facebook.presto.sql.tree.RenameColumn;
import com.facebook.presto.sql.tree.RenameTable;
import com.facebook.presto.sql.tree.ShowCatalogs;
import com.facebook.presto.sql.tree.ShowColumns;
import com.facebook.presto.sql.tree.ShowFunctions;
import com.facebook.presto.sql.tree.ShowPartitions;
import com.facebook.presto.sql.tree.ShowSchemas;
import com.facebook.presto.sql.tree.ShowSession;
import com.facebook.presto.sql.tree.ShowTables;
import com.facebook.presto.sql.tree.Statement;
import com.facebook.presto.util.ImmutableCollectors;
import com.facebook.presto.verifier.ForwardingDriver;
import com.facebook.presto.verifier.PrestoVerifierModule;
import com.facebook.presto.verifier.Query;
import com.facebook.presto.verifier.QueryPair;
import com.facebook.presto.verifier.QueryType;
import com.facebook.presto.verifier.Verifier;
import com.facebook.presto.verifier.VerifierConfig;
import com.facebook.presto.verifier.VerifierDao;
import com.google.common.base.Preconditions;
import com.google.common.base.Throwables;
import com.google.common.collect.ImmutableList;
import com.google.inject.Injector;
import com.google.inject.Key;
import com.google.inject.Module;
import com.google.inject.TypeLiteral;
import com.google.inject.name.Names;
import io.airlift.bootstrap.Bootstrap;
import io.airlift.bootstrap.LifeCycleManager;
import io.airlift.event.client.EventClient;
import java.io.File;
import java.lang.annotation.Annotation;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLClassLoader;
import java.nio.file.Paths;
import java.sql.Driver;
import java.sql.DriverManager;
import java.util.EnumSet;
import java.util.List;
import java.util.Optional;
import java.util.Set;
import org.skife.jdbi.v2.DBI;

public class PrestoVerifier {
    public static final String SUPPORTED_EVENT_CLIENTS = "SUPPORTED_EVENT_CLIENTS";

    protected PrestoVerifier() {
    }

    public static void main(String[] args) throws Exception {
        int failed = new PrestoVerifier().run(args);
        System.exit(failed > 0 ? 1 : 0);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int run(String[] args) throws Exception {
        if (args.length > 0) {
            System.setProperty("config", args[0]);
        }
        ImmutableList.Builder builder = ImmutableList.builder().add((Object)new PrestoVerifierModule()).addAll(this.getAdditionalModules());
        Bootstrap app = new Bootstrap((Iterable)builder.build());
        Injector injector = app.strictConfig().initialize();
        try {
            VerifierConfig config = (VerifierConfig)injector.getInstance(VerifierConfig.class);
            injector.injectMembers((Object)this);
            Set supportedEventClients = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<String>>(){}, (Annotation)Names.named((String)SUPPORTED_EVENT_CLIENTS)));
            for (String clientType : config.getEventClients()) {
                Preconditions.checkArgument((boolean)supportedEventClients.contains(clientType), (String)"Unsupported event client: %s", (Object[])new Object[]{clientType});
            }
            Set eventClients = (Set)injector.getInstance(Key.get((TypeLiteral)new TypeLiteral<Set<EventClient>>(){}));
            VerifierDao dao = (VerifierDao)new DBI(config.getQueryDatabase()).onDemand(VerifierDao.class);
            ImmutableList.Builder queriesBuilder = ImmutableList.builder();
            for (String suite : config.getSuites()) {
                queriesBuilder.addAll(dao.getQueriesBySuite(suite, config.getMaxQueries()));
            }
            Object queries = queriesBuilder.build();
            queries = PrestoVerifier.applyOverrides(config, (List<QueryPair>)queries);
            queries = PrestoVerifier.filterQueryTypes(new SqlParser(this.getParserOptions()), config, (List<QueryPair>)queries);
            queries = this.filterQueries((List<QueryPair>)queries);
            if (config.getAdditionalJdbcDriverPath() != null) {
                List<URL> urlList = PrestoVerifier.getUrls(config.getAdditionalJdbcDriverPath());
                URL[] urls = new URL[urlList.size()];
                urlList.toArray(urls);
                if (config.getTestJdbcDriverName() != null) {
                    PrestoVerifier.loadJdbcDriver(urls, config.getTestJdbcDriverName());
                }
                if (config.getControlJdbcDriverName() != null) {
                    PrestoVerifier.loadJdbcDriver(urls, config.getControlJdbcDriverName());
                }
            }
            Verifier verifier = new Verifier(System.out, config, eventClients);
            int n = verifier.run((List<QueryPair>)queries);
            return n;
        }
        finally {
            ((LifeCycleManager)injector.getInstance(LifeCycleManager.class)).stop();
        }
    }

    private static void loadJdbcDriver(URL[] urls, String jdbcClassName) {
        try (URLClassLoader classLoader = new URLClassLoader(urls);){
            Driver driver = (Driver)Class.forName(jdbcClassName, true, classLoader).getConstructor(new Class[0]).newInstance(new Object[0]);
            DriverManager.registerDriver(new ForwardingDriver(driver));
        }
        catch (Exception e) {
            throw Throwables.propagate((Throwable)e);
        }
    }

    private static List<URL> getUrls(String path) throws MalformedURLException {
        ImmutableList.Builder urlList = ImmutableList.builder();
        File driverPath = new File(path);
        if (!driverPath.isDirectory()) {
            urlList.add((Object)Paths.get(path, new String[0]).toUri().toURL());
            return urlList.build();
        }
        File[] files = driverPath.listFiles((dir, name) -> name.endsWith(".jar"));
        if (files == null) {
            return urlList.build();
        }
        for (File file : files) {
            if (file.isDirectory()) continue;
            urlList.add((Object)Paths.get(file.getAbsolutePath(), new String[0]).toUri().toURL());
        }
        return urlList.build();
    }

    protected SqlParserOptions getParserOptions() {
        return new SqlParserOptions();
    }

    protected List<QueryPair> filterQueries(List<QueryPair> queries) {
        return queries;
    }

    private static List<QueryPair> filterQueryTypes(SqlParser parser, VerifierConfig config, List<QueryPair> queries) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (QueryPair pair : queries) {
            if (!PrestoVerifier.queryTypeAllowed(parser, config.getControlQueryTypes(), pair.getControl()) || !PrestoVerifier.queryTypeAllowed(parser, config.getTestQueryTypes(), pair.getTest())) continue;
            builder.add((Object)pair);
        }
        return builder.build();
    }

    private static boolean queryTypeAllowed(SqlParser parser, Set<QueryType> allowedTypes, Query query) {
        EnumSet<QueryType> types = EnumSet.noneOf(QueryType.class);
        try {
            for (String sql : query.getPreQueries()) {
                types.add(PrestoVerifier.statementToQueryType(parser, sql));
            }
            types.add(PrestoVerifier.statementToQueryType(parser, query.getQuery()));
            for (String sql : query.getPostQueries()) {
                types.add(PrestoVerifier.statementToQueryType(parser, sql));
            }
        }
        catch (UnsupportedOperationException e) {
            return false;
        }
        return allowedTypes.containsAll(types);
    }

    private static QueryType statementToQueryType(SqlParser parser, String sql) {
        try {
            return PrestoVerifier.statementToQueryType(parser.createStatement(sql));
        }
        catch (RuntimeException e) {
            throw new UnsupportedOperationException();
        }
    }

    private static QueryType statementToQueryType(Statement statement) {
        if (statement instanceof AddColumn) {
            return QueryType.MODIFY;
        }
        if (statement instanceof CreateTable) {
            return QueryType.CREATE;
        }
        if (statement instanceof CreateTableAsSelect) {
            return QueryType.CREATE;
        }
        if (statement instanceof CreateView) {
            if (((CreateView)statement).isReplace()) {
                return QueryType.MODIFY;
            }
            return QueryType.CREATE;
        }
        if (statement instanceof Delete) {
            return QueryType.MODIFY;
        }
        if (statement instanceof DropTable) {
            return QueryType.MODIFY;
        }
        if (statement instanceof DropView) {
            return QueryType.MODIFY;
        }
        if (statement instanceof Explain) {
            if (((Explain)statement).isAnalyze()) {
                return PrestoVerifier.statementToQueryType(((Explain)statement).getStatement());
            }
            return QueryType.READ;
        }
        if (statement instanceof Insert) {
            return QueryType.MODIFY;
        }
        if (statement instanceof com.facebook.presto.sql.tree.Query) {
            return QueryType.READ;
        }
        if (statement instanceof RenameColumn) {
            return QueryType.MODIFY;
        }
        if (statement instanceof RenameTable) {
            return QueryType.MODIFY;
        }
        if (statement instanceof ShowCatalogs) {
            return QueryType.READ;
        }
        if (statement instanceof ShowColumns) {
            return QueryType.READ;
        }
        if (statement instanceof ShowFunctions) {
            return QueryType.READ;
        }
        if (statement instanceof ShowPartitions) {
            return QueryType.READ;
        }
        if (statement instanceof ShowSchemas) {
            return QueryType.READ;
        }
        if (statement instanceof ShowSession) {
            return QueryType.READ;
        }
        if (statement instanceof ShowTables) {
            return QueryType.READ;
        }
        throw new UnsupportedOperationException();
    }

    protected Iterable<Module> getAdditionalModules() {
        return ImmutableList.of();
    }

    private static List<QueryPair> applyOverrides(VerifierConfig config, List<QueryPair> queries) {
        return (List)queries.stream().map(input -> {
            Query test = new Query(Optional.ofNullable(config.getTestCatalogOverride()).orElse(input.getTest().getCatalog()), Optional.ofNullable(config.getTestSchemaOverride()).orElse(input.getTest().getSchema()), input.getTest().getPreQueries(), input.getTest().getQuery(), input.getTest().getPostQueries(), Optional.ofNullable(config.getTestUsernameOverride()).orElse(input.getTest().getUsername()), Optional.ofNullable(config.getTestPasswordOverride()).orElse(Optional.ofNullable(input.getTest().getPassword()).orElse(null)), input.getTest().getSessionProperties());
            Query control = new Query(Optional.ofNullable(config.getControlCatalogOverride()).orElse(input.getControl().getCatalog()), Optional.ofNullable(config.getControlSchemaOverride()).orElse(input.getControl().getSchema()), input.getControl().getPreQueries(), input.getControl().getQuery(), input.getControl().getPostQueries(), Optional.ofNullable(config.getControlUsernameOverride()).orElse(input.getControl().getUsername()), Optional.ofNullable(config.getControlPasswordOverride()).orElse(Optional.ofNullable(input.getControl().getPassword()).orElse(null)), input.getControl().getSessionProperties());
            return new QueryPair(input.getSuite(), input.getName(), test, control);
        }).collect(ImmutableCollectors.toImmutableList());
    }
}

