/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier;

import com.facebook.presto.util.ImmutableCollectors;
import com.google.common.collect.ImmutableMap;
import java.util.List;
import java.util.Map;

public class Query {
    private final String catalog;
    private final String schema;
    private final List<String> preQueries;
    private final String query;
    private final List<String> postQueries;
    private final String username;
    private final String password;
    private final Map<String, String> sessionProperties;

    public Query(String catalog, String schema, List<String> preQueries, String query, List<String> postQueries, String username, String password, Map<String, String> sessionProperties) {
        this.catalog = catalog;
        this.schema = schema;
        this.preQueries = (List)preQueries.stream().map(Query::clean).collect(ImmutableCollectors.toImmutableList());
        this.query = Query.clean(query);
        this.postQueries = (List)postQueries.stream().map(Query::clean).collect(ImmutableCollectors.toImmutableList());
        this.username = username;
        this.password = password;
        this.sessionProperties = ImmutableMap.copyOf(sessionProperties);
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public List<String> getPreQueries() {
        return this.preQueries;
    }

    public String getQuery() {
        return this.query;
    }

    public List<String> getPostQueries() {
        return this.postQueries;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Map<String, String> getSessionProperties() {
        return this.sessionProperties;
    }

    private static String clean(String sql) {
        sql = sql.replaceAll("\t", "  ");
        sql = sql.replaceAll("\n+", "\n");
        sql = sql.trim();
        while (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1).trim();
        }
        return sql;
    }
}

