/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier;

import com.google.common.collect.ImmutableList;
import io.airlift.units.Duration;
import java.util.List;
import java.util.Objects;

public class QueryResult {
    private final State state;
    private final Exception exception;
    private final Duration duration;
    private final List<List<Object>> results;

    public QueryResult(State state, Exception exception, Duration duration, List<List<Object>> results) {
        this.state = Objects.requireNonNull(state, "state is null");
        this.exception = exception;
        this.duration = duration;
        this.results = results != null ? ImmutableList.copyOf(results) : null;
    }

    public State getState() {
        return this.state;
    }

    public Exception getException() {
        return this.exception;
    }

    public Duration getDuration() {
        return this.duration;
    }

    public List<List<Object>> getResults() {
        return this.results;
    }

    public static enum State {
        INVALID,
        FAILED,
        SUCCESS,
        TOO_MANY_ROWS,
        TIMEOUT;

    }
}

