/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.verifier;

import com.google.common.collect.ImmutableMap;
import java.util.Map;

public class Query {
    private final String catalog;
    private final String schema;
    private final String query;
    private final String username;
    private final String password;
    private final Map<String, String> sessionProperties;

    public Query(String catalog, String schema, String query, String username, String password, Map<String, String> sessionProperties) {
        this.catalog = catalog;
        this.schema = schema;
        this.query = Query.clean(query);
        this.username = username;
        this.password = password;
        this.sessionProperties = ImmutableMap.copyOf(sessionProperties);
    }

    public String getCatalog() {
        return this.catalog;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getQuery() {
        return this.query;
    }

    public String getUsername() {
        return this.username;
    }

    public String getPassword() {
        return this.password;
    }

    public Map<String, String> getSessionProperties() {
        return this.sessionProperties;
    }

    private static String clean(String sql) {
        sql = sql.replaceAll("\t", "  ");
        sql = sql.replaceAll("\n+", "\n");
        sql = sql.trim();
        while (sql.endsWith(";")) {
            sql = sql.substring(0, sql.length() - 1).trim();
        }
        return sql;
    }
}

