/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpch;

import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorRecordSetProvider;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchRecordSet;
import com.facebook.presto.tpch.TpchSplit;
import com.facebook.presto.tpch.Types;
import com.google.common.collect.ImmutableList;
import io.airlift.tpch.TpchColumn;
import io.airlift.tpch.TpchColumnType;
import io.airlift.tpch.TpchEntity;
import io.airlift.tpch.TpchTable;
import java.util.List;

public class TpchRecordSetProvider
implements ConnectorRecordSetProvider {
    public RecordSet getRecordSet(ConnectorSplit split, List<? extends ConnectorColumnHandle> columns) {
        TpchSplit tpchSplit = Types.checkType(split, TpchSplit.class, "split");
        String tableName = tpchSplit.getTableHandle().getTableName();
        TpchTable tpchTable = TpchTable.getTable((String)tableName);
        return this.getRecordSet(tpchTable, columns, tpchSplit.getTableHandle().getScaleFactor(), tpchSplit.getPartNumber(), tpchSplit.getTotalParts());
    }

    public <E extends TpchEntity> RecordSet getRecordSet(TpchTable<E> table, List<? extends ConnectorColumnHandle> columns, double scaleFactor, int partNumber, int totalParts) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ConnectorColumnHandle connectorColumnHandle : columns) {
            String columnName = Types.checkType(connectorColumnHandle, TpchColumnHandle.class, "column").getColumnName();
            if (columnName.equalsIgnoreCase("row_number")) {
                builder.add(new RowNumberTpchColumn());
                continue;
            }
            builder.add((Object)table.getColumn(columnName));
        }
        return TpchRecordSet.createTpchRecordSet(table, builder.build(), scaleFactor, partNumber + 1, totalParts);
    }

    private static class RowNumberTpchColumn<E extends TpchEntity>
    implements TpchColumn<E> {
        private RowNumberTpchColumn() {
        }

        public String getColumnName() {
            throw new UnsupportedOperationException();
        }

        public TpchColumnType getType() {
            return TpchColumnType.BIGINT;
        }

        public double getDouble(E entity) {
            throw new UnsupportedOperationException();
        }

        public long getLong(E entity) {
            return entity.getRowNumber();
        }

        public String getString(E entity) {
            throw new UnsupportedOperationException();
        }

        public int getDate(E entity) {
            throw new UnsupportedOperationException();
        }
    }
}

