/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpch;

import com.facebook.presto.spi.ConnectorTableHandle;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;

public class TpchTableHandle
implements ConnectorTableHandle {
    private final String connectorId;
    private final String tableName;
    private final double scaleFactor;

    @JsonCreator
    public TpchTableHandle(@JsonProperty(value="connectorId") String connectorId, @JsonProperty(value="tableName") String tableName, @JsonProperty(value="scaleFactor") double scaleFactor) {
        this.connectorId = (String)Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null");
        this.tableName = (String)Preconditions.checkNotNull((Object)tableName, (Object)"tableName is null");
        Preconditions.checkArgument((scaleFactor > 0.0 ? 1 : 0) != 0, (Object)"Scale factor must be larger than 0");
        this.scaleFactor = scaleFactor;
    }

    @JsonProperty
    public String getConnectorId() {
        return this.connectorId;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public String toString() {
        return "tpch:" + this.tableName + ":sf" + this.scaleFactor;
    }

    public int hashCode() {
        return Objects.hashCode((Object[])new Object[]{this.connectorId, this.tableName, this.scaleFactor});
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TpchTableHandle other = (TpchTableHandle)obj;
        return Objects.equal((Object)this.tableName, (Object)other.tableName) && Objects.equal((Object)this.scaleFactor, (Object)other.scaleFactor) && Objects.equal((Object)this.connectorId, (Object)other.connectorId);
    }
}

