/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpch;

import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.ReadOnlyConnectorMetadata;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.BooleanType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchTableHandle;
import com.facebook.presto.tpch.Types;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.tpch.TpchColumn;
import io.airlift.tpch.TpchTable;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class TpchMetadata
extends ReadOnlyConnectorMetadata {
    public static final String TINY_SCHEMA_NAME = "tiny";
    public static final double TINY_SCALE_FACTOR = 0.01;
    public static final String ROW_NUMBER_COLUMN_NAME = "row_number";
    private static final TpchColumnHandle ROW_NUMBER_COLUMN_HANDLE = new TpchColumnHandle("row_number", -1, (Type)BigintType.BIGINT);
    private final String connectorId;
    private final Set<String> tableNames;

    public TpchMetadata(String connectorId) {
        ImmutableSet.Builder tableNames = ImmutableSet.builder();
        for (TpchTable tpchTable : TpchTable.getTables()) {
            tableNames.add((Object)tpchTable.getTableName());
        }
        this.tableNames = tableNames.build();
        this.connectorId = connectorId;
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return ImmutableList.of((Object)TINY_SCHEMA_NAME, (Object)"sf1", (Object)"sf100", (Object)"sf300", (Object)"sf1000", (Object)"sf3000", (Object)"sf10000", (Object)"sf30000", (Object)"sf100000");
    }

    public TpchTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Preconditions.checkNotNull((Object)tableName, (Object)"tableName is null");
        if (!this.tableNames.contains(tableName.getTableName())) {
            return null;
        }
        double scaleFactor = TpchMetadata.schemaNameToScaleFactor(tableName.getSchemaName());
        if (scaleFactor < 0.0) {
            return null;
        }
        return new TpchTableHandle(this.connectorId, tableName.getTableName(), scaleFactor);
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorTableHandle tableHandle) {
        TpchTableHandle tpchTableHandle = Types.checkType(tableHandle, TpchTableHandle.class, "tableHandle");
        TpchTable tpchTable = TpchTable.getTable((String)tpchTableHandle.getTableName());
        String schemaName = TpchMetadata.scaleFactorSchemaName(tpchTableHandle.getScaleFactor());
        return TpchMetadata.getTableMetadata(schemaName, tpchTable);
    }

    private static ConnectorTableMetadata getTableMetadata(String schemaName, TpchTable<?> tpchTable) {
        ImmutableList.Builder columns = ImmutableList.builder();
        int ordinalPosition = 0;
        for (TpchColumn column : tpchTable.getColumns()) {
            columns.add((Object)new ColumnMetadata(column.getColumnName(), TpchMetadata.getPrestoType(column.getType()), ordinalPosition, false));
            ++ordinalPosition;
        }
        columns.add((Object)new ColumnMetadata(ROW_NUMBER_COLUMN_NAME, (Type)BigintType.BIGINT, ordinalPosition, false, true));
        SchemaTableName tableName = new SchemaTableName(schemaName, tpchTable.getTableName());
        return new ConnectorTableMetadata(tableName, (List)columns.build());
    }

    public Map<String, ConnectorColumnHandle> getColumnHandles(ConnectorTableHandle tableHandle) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ColumnMetadata columnMetadata : this.getTableMetadata(tableHandle).getColumns()) {
            builder.put((Object)columnMetadata.getName(), (Object)new TpchColumnHandle(columnMetadata.getName(), columnMetadata.getOrdinalPosition(), columnMetadata.getType()));
        }
        return builder.build();
    }

    public ConnectorColumnHandle getColumnHandle(ConnectorTableHandle tableHandle, String columnName) {
        TpchTableHandle tpchTableHandle = Types.checkType(tableHandle, TpchTableHandle.class, "tableHandle");
        if (columnName.equalsIgnoreCase(ROW_NUMBER_COLUMN_NAME)) {
            return ROW_NUMBER_COLUMN_HANDLE;
        }
        int ordinalPosition = 0;
        for (TpchColumn column : TpchTable.getTable((String)tpchTableHandle.getTableName()).getColumns()) {
            if (column.getColumnName().equalsIgnoreCase(columnName)) {
                return new TpchColumnHandle(column.getColumnName(), ordinalPosition, TpchMetadata.getPrestoType(column.getType()));
            }
            ++ordinalPosition;
        }
        return null;
    }

    public ConnectorColumnHandle getSampleWeightColumnHandle(ConnectorTableHandle tableHandle) {
        return null;
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        ImmutableMap.Builder tableColumns = ImmutableMap.builder();
        for (String schemaName : this.getSchemaNames(session, prefix.getSchemaName())) {
            for (TpchTable tpchTable : TpchTable.getTables()) {
                if (prefix.getTableName() != null && !tpchTable.getTableName().equals(prefix.getTableName())) continue;
                ConnectorTableMetadata tableMetadata = TpchMetadata.getTableMetadata(schemaName, tpchTable);
                tableColumns.put((Object)new SchemaTableName(schemaName, tpchTable.getTableName()), (Object)tableMetadata.getColumns());
            }
        }
        return tableColumns.build();
    }

    public ColumnMetadata getColumnMetadata(ConnectorTableHandle tableHandle, ConnectorColumnHandle columnHandle) {
        ConnectorTableMetadata tableMetadata = this.getTableMetadata(tableHandle);
        String columnName = Types.checkType(columnHandle, TpchColumnHandle.class, "columnHandle").getColumnName();
        for (ColumnMetadata column : tableMetadata.getColumns()) {
            if (!column.getName().equals(columnName)) continue;
            return column;
        }
        throw new IllegalArgumentException(String.format("Table %s does not have column %s", tableMetadata.getTable(), columnName));
    }

    public List<SchemaTableName> listTables(ConnectorSession session, String schemaNameOrNull) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String schemaName : this.getSchemaNames(session, schemaNameOrNull)) {
            for (TpchTable tpchTable : TpchTable.getTables()) {
                builder.add((Object)new SchemaTableName(schemaName, tpchTable.getTableName()));
            }
        }
        return builder.build();
    }

    private List<String> getSchemaNames(ConnectorSession session, String schemaNameOrNull) {
        ImmutableList schemaNames = schemaNameOrNull == null ? this.listSchemaNames(session) : (TpchMetadata.schemaNameToScaleFactor(schemaNameOrNull) > 0.0 ? ImmutableList.of((Object)schemaNameOrNull) : ImmutableList.of());
        return schemaNames;
    }

    private static String scaleFactorSchemaName(double scaleFactor) {
        return "sf" + scaleFactor;
    }

    private static double schemaNameToScaleFactor(String schemaName) {
        if (TINY_SCHEMA_NAME.equals(schemaName)) {
            return 0.01;
        }
        if (!schemaName.startsWith("sf")) {
            return -1.0;
        }
        try {
            return Double.parseDouble(schemaName.substring(2));
        }
        catch (Exception ignored) {
            return -1.0;
        }
    }

    public static Type getPrestoType(Class<?> javaType) {
        if (javaType == Boolean.class) {
            return BooleanType.BOOLEAN;
        }
        if (javaType == Long.class) {
            return BigintType.BIGINT;
        }
        if (javaType == Double.class) {
            return DoubleType.DOUBLE;
        }
        if (javaType == String.class) {
            return VarcharType.VARCHAR;
        }
        throw new IllegalArgumentException("Unsupported type " + javaType.getName());
    }
}

