/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpch;

import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorRecordSetProvider;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchRecordSet;
import com.facebook.presto.tpch.TpchSplit;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import io.airlift.tpch.TpchEntity;
import io.airlift.tpch.TpchTable;
import java.util.List;

public class TpchRecordSetProvider
implements ConnectorRecordSetProvider {
    private final String connectorId;

    public TpchRecordSetProvider(String connectorId) {
        this.connectorId = connectorId;
    }

    public RecordSet getRecordSet(ConnectorSplit split, List<? extends ConnectorColumnHandle> columns) {
        Preconditions.checkNotNull((Object)split, (Object)"split is null");
        Preconditions.checkArgument((boolean)(split instanceof TpchSplit), (Object)"Split must be a tpch split!");
        Preconditions.checkNotNull(columns, (Object)"columns is null");
        Preconditions.checkArgument((!columns.isEmpty() ? 1 : 0) != 0, (Object)"must provide at least one column");
        TpchSplit tpchSplit = (TpchSplit)split;
        String tableName = tpchSplit.getTableHandle().getTableName();
        TpchTable tpchTable = TpchTable.getTable((String)tableName);
        return this.getRecordSet(tpchTable, columns, tpchSplit);
    }

    private <E extends TpchEntity> RecordSet getRecordSet(TpchTable<E> table, List<? extends ConnectorColumnHandle> columns, TpchSplit tpchSplit) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ConnectorColumnHandle connectorColumnHandle : columns) {
            Preconditions.checkArgument((boolean)(connectorColumnHandle instanceof TpchColumnHandle), (String)"column must be of type TpchColumnHandle, not %s", (Object[])new Object[]{connectorColumnHandle.getClass().getName()});
            String columnName = ((TpchColumnHandle)connectorColumnHandle).getColumnName();
            builder.add((Object)table.getColumn(columnName));
        }
        return TpchRecordSet.createTpchRecordSet(table, builder.build(), tpchSplit.getTableHandle().getScaleFactor(), tpchSplit.getPartNumber() + 1, tpchSplit.getTotalParts());
    }
}

