/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpch;

import com.facebook.presto.spi.ConnectorColumnHandle;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorIndexHandle;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchSplit;
import com.facebook.presto.tpch.TpchTableHandle;
import com.google.common.base.Preconditions;

public class TpchHandleResolver
implements ConnectorHandleResolver {
    private final String connectorId;

    public TpchHandleResolver(String connectorId) {
        this.connectorId = (String)Preconditions.checkNotNull((Object)connectorId, (Object)"connectorId is null");
    }

    public boolean canHandle(ConnectorTableHandle tableHandle) {
        return tableHandle instanceof TpchTableHandle && ((TpchTableHandle)tableHandle).getConnectorId().equals(this.connectorId);
    }

    public boolean canHandle(ConnectorColumnHandle columnHandle) {
        return columnHandle instanceof TpchColumnHandle;
    }

    public boolean canHandle(ConnectorSplit split) {
        return split instanceof TpchSplit && ((TpchSplit)split).getTableHandle().getConnectorId().equals(this.connectorId);
    }

    public boolean canHandle(ConnectorIndexHandle indexHandle) {
        return false;
    }

    public Class<? extends ConnectorTableHandle> getTableHandleClass() {
        return TpchTableHandle.class;
    }

    public Class<? extends ConnectorColumnHandle> getColumnHandleClass() {
        return TpchColumnHandle.class;
    }

    public Class<? extends ConnectorSplit> getSplitClass() {
        return TpchSplit.class;
    }

    public Class<? extends ConnectorIndexHandle> getIndexHandleClass() {
        throw new UnsupportedOperationException();
    }
}

