/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpch;

import com.facebook.presto.spi.Connector;
import com.facebook.presto.spi.ConnectorFactory;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorIndexResolver;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.ConnectorOutputHandleResolver;
import com.facebook.presto.spi.ConnectorRecordSetProvider;
import com.facebook.presto.spi.ConnectorRecordSinkProvider;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.tpch.TpchHandleResolver;
import com.facebook.presto.tpch.TpchMetadata;
import com.facebook.presto.tpch.TpchRecordSetProvider;
import com.facebook.presto.tpch.TpchSplitManager;
import com.google.common.base.Objects;
import com.google.common.base.Preconditions;
import java.util.Map;

public class TpchConnectorFactory
implements ConnectorFactory {
    private final NodeManager nodeManager;
    private final int defaultSplitsPerNode;

    public TpchConnectorFactory(NodeManager nodeManager) {
        this(nodeManager, Runtime.getRuntime().availableProcessors());
    }

    public TpchConnectorFactory(NodeManager nodeManager, int defaultSplitsPerNode) {
        this.nodeManager = (NodeManager)Preconditions.checkNotNull((Object)nodeManager, (Object)"nodeManager is null");
        this.defaultSplitsPerNode = defaultSplitsPerNode;
    }

    public String getName() {
        return "tpch";
    }

    public Connector create(final String connectorId, Map<String, String> properties) {
        final int splitsPerNode = this.getSplitsPerNode(properties);
        return new Connector(){

            public ConnectorMetadata getMetadata() {
                return new TpchMetadata(connectorId);
            }

            public ConnectorSplitManager getSplitManager() {
                return new TpchSplitManager(connectorId, TpchConnectorFactory.this.nodeManager, splitsPerNode);
            }

            public ConnectorHandleResolver getHandleResolver() {
                return new TpchHandleResolver(connectorId);
            }

            public ConnectorRecordSetProvider getRecordSetProvider() {
                return new TpchRecordSetProvider(connectorId);
            }

            public ConnectorRecordSinkProvider getRecordSinkProvider() {
                throw new UnsupportedOperationException();
            }

            public ConnectorOutputHandleResolver getOutputHandleResolver() {
                throw new UnsupportedOperationException();
            }

            public ConnectorIndexResolver getIndexResolver() {
                throw new UnsupportedOperationException();
            }
        };
    }

    private int getSplitsPerNode(Map<String, String> properties) {
        try {
            return Integer.parseInt((String)Objects.firstNonNull((Object)properties.get("tpch.splits-per-node"), (Object)String.valueOf(this.defaultSplitsPerNode)));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid property tpch.splits-per-node");
        }
    }
}

