/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpch;

import com.facebook.presto.spi.ConnectorTableHandle;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.google.common.base.Preconditions;
import java.util.Objects;

public class TpchTableHandle
implements ConnectorTableHandle {
    private final String tableName;
    private final double scaleFactor;

    @JsonCreator
    public TpchTableHandle(@JsonProperty(value="tableName") String tableName, @JsonProperty(value="scaleFactor") double scaleFactor) {
        this.tableName = Objects.requireNonNull(tableName, "tableName is null");
        Preconditions.checkArgument((scaleFactor > 0.0 ? 1 : 0) != 0, (Object)"Scale factor must be larger than 0");
        this.scaleFactor = scaleFactor;
    }

    @JsonProperty
    public String getTableName() {
        return this.tableName;
    }

    @JsonProperty
    public double getScaleFactor() {
        return this.scaleFactor;
    }

    public String toString() {
        return this.tableName + ":sf" + this.scaleFactor;
    }

    public int hashCode() {
        return Objects.hash(this.tableName, this.scaleFactor);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TpchTableHandle other = (TpchTableHandle)obj;
        return Objects.equals(this.tableName, other.tableName) && Objects.equals(this.scaleFactor, other.scaleFactor);
    }
}

