/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpch;

import com.facebook.presto.spi.BucketFunction;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.connector.ConnectorNodePartitioningProvider;
import com.facebook.presto.spi.connector.ConnectorPartitioningHandle;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.tpch.TpchBucketFunction;
import com.facebook.presto.tpch.TpchPartitioningHandle;
import com.facebook.presto.tpch.TpchSplit;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;
import java.util.function.ToIntFunction;

public class TpchNodePartitioningProvider
implements ConnectorNodePartitioningProvider {
    private final NodeManager nodeManager;
    private final int splitsPerNode;

    public TpchNodePartitioningProvider(NodeManager nodeManager, int splitsPerNode) {
        this.nodeManager = nodeManager;
        Preconditions.checkArgument((splitsPerNode > 0 ? 1 : 0) != 0, (Object)"splitsPerNode must be at least 1");
        this.splitsPerNode = splitsPerNode;
    }

    public ConnectorNodePartitioningProvider.ConnectorBucketNodeMap getBucketNodeMap(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        Set nodes = this.nodeManager.getRequiredWorkerNodes();
        return ConnectorNodePartitioningProvider.ConnectorBucketNodeMap.createBucketNodeMap((int)Math.toIntExact((long)nodes.size() * (long)this.splitsPerNode));
    }

    public ToIntFunction<ConnectorSplit> getSplitBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle) {
        return value -> ((TpchSplit)value).getPartNumber();
    }

    public BucketFunction getBucketFunction(ConnectorTransactionHandle transactionHandle, ConnectorSession session, ConnectorPartitioningHandle partitioningHandle, List<Type> partitionChannelTypes, int bucketCount) {
        long totalRows = ((TpchPartitioningHandle)partitioningHandle).getTotalRows();
        long rowsPerBucket = totalRows / (long)bucketCount;
        Preconditions.checkArgument((boolean)partitionChannelTypes.equals(ImmutableList.of((Object)BigintType.BIGINT)), (Object)"Expected one BIGINT parameter");
        return new TpchBucketFunction(bucketCount, rowsPerBucket);
    }
}

