/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpch;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ErrorCodeSupplier;
import com.facebook.presto.spi.PrestoException;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.StandardErrorCode;
import com.facebook.presto.spi.predicate.NullableValue;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchMetadata;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.tpch.TpchColumn;
import io.airlift.tpch.TpchColumnType;
import io.airlift.tpch.TpchEntity;
import io.airlift.tpch.TpchTable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.function.Predicate;
import java.util.stream.Collectors;

public class TpchRecordSet<E extends TpchEntity>
implements RecordSet {
    private final Iterable<E> table;
    private final List<TpchColumn<E>> columns;
    private final List<Type> columnTypes;
    private final List<TpchColumnHandle> columnHandles;
    private final Optional<Predicate<Map<ColumnHandle, NullableValue>>> predicate;

    public static <E extends TpchEntity> TpchRecordSet<E> createTpchRecordSet(TpchTable<E> table, double scaleFactor) {
        return TpchRecordSet.createTpchRecordSet(table, table.getColumns(), scaleFactor, 1, 1, Optional.empty());
    }

    public static <E extends TpchEntity> TpchRecordSet<E> createTpchRecordSet(TpchTable<E> table, Iterable<TpchColumn<E>> columns, double scaleFactor, int part, int partCount, Optional<TupleDomain<ColumnHandle>> predicate) {
        return new TpchRecordSet<E>(table.createGenerator(scaleFactor, part, partCount), columns, predicate);
    }

    public TpchRecordSet(Iterable<E> table, Iterable<TpchColumn<E>> columns, Optional<TupleDomain<ColumnHandle>> predicate) {
        Objects.requireNonNull(table, "readerSupplier is null");
        this.table = table;
        this.columns = ImmutableList.copyOf(columns);
        this.columnTypes = ImmutableList.copyOf((Iterable)Iterables.transform(columns, column -> TpchMetadata.getPrestoType(column.getType())));
        this.columnHandles = this.columns.stream().map(column -> new TpchColumnHandle(column.getColumnName(), TpchMetadata.getPrestoType(column.getType()))).collect(Collectors.toList());
        this.predicate = predicate.map(TpchRecordSet::convertToPredicate);
    }

    static Predicate<Map<ColumnHandle, NullableValue>> convertToPredicate(TupleDomain<ColumnHandle> tupleDomain) {
        return bindings -> tupleDomain.contains(TupleDomain.fromFixedValues((Map)bindings));
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    public RecordCursor cursor() {
        return new TpchRecordCursor<E>(this.table.iterator(), this.columns);
    }

    public class TpchRecordCursor<E extends TpchEntity>
    implements RecordCursor {
        private final Iterator<E> rows;
        private final List<TpchColumn<E>> columns;
        private E row;
        private boolean closed;

        public TpchRecordCursor(Iterator<E> rows, List<TpchColumn<E>> columns) {
            this.rows = rows;
            this.columns = columns;
        }

        public long getCompletedBytes() {
            return 0L;
        }

        public long getReadTimeNanos() {
            return 0L;
        }

        public Type getType(int field) {
            return TpchMetadata.getPrestoType(this.getTpchColumn(field).getType());
        }

        public boolean advanceNextPosition() {
            while (!this.closed && this.rows.hasNext()) {
                this.row = (TpchEntity)this.rows.next();
                if (!this.rowMatchesPredicate()) continue;
                return true;
            }
            this.closed = true;
            this.row = null;
            return false;
        }

        public boolean getBoolean(int field) {
            throw new UnsupportedOperationException();
        }

        public long getLong(int field) {
            Preconditions.checkState((this.row != null ? 1 : 0) != 0, (Object)"No current row");
            TpchColumn<E> tpchColumn = this.getTpchColumn(field);
            if (tpchColumn.getType().getBase() == TpchColumnType.Base.DATE) {
                return tpchColumn.getDate(this.row);
            }
            if (tpchColumn.getType().getBase() == TpchColumnType.Base.INTEGER) {
                return tpchColumn.getInteger(this.row);
            }
            return tpchColumn.getIdentifier(this.row);
        }

        public double getDouble(int field) {
            Preconditions.checkState((this.row != null ? 1 : 0) != 0, (Object)"No current row");
            return this.getTpchColumn(field).getDouble(this.row);
        }

        public Slice getSlice(int field) {
            Preconditions.checkState((this.row != null ? 1 : 0) != 0, (Object)"No current row");
            return Slices.utf8Slice((String)this.getTpchColumn(field).getString(this.row));
        }

        public Object getObject(int field) {
            throw new UnsupportedOperationException();
        }

        public boolean isNull(int field) {
            return false;
        }

        public void close() {
            this.row = null;
            this.closed = true;
        }

        private boolean rowMatchesPredicate() {
            if (!TpchRecordSet.this.predicate.isPresent()) {
                return true;
            }
            return ((Predicate)TpchRecordSet.this.predicate.get()).test(this.rowMap());
        }

        private Map<ColumnHandle, NullableValue> rowMap() {
            ImmutableMap.Builder builder = ImmutableMap.builder();
            for (int field = 0; field < TpchRecordSet.this.columnHandles.size(); ++field) {
                Type type = (Type)TpchRecordSet.this.columnTypes.get(field);
                builder.put(TpchRecordSet.this.columnHandles.get(field), (Object)NullableValue.of((Type)type, (Object)this.getPrestoObject(field, type)));
            }
            return builder.build();
        }

        private Object getPrestoObject(int field, Type type) {
            if (type.getJavaType() == Long.TYPE) {
                return this.getLong(field);
            }
            if (type.getJavaType() == Double.TYPE) {
                return this.getDouble(field);
            }
            if (type.getJavaType() == Slice.class) {
                return this.getSlice(field);
            }
            throw new PrestoException((ErrorCodeSupplier)StandardErrorCode.NOT_SUPPORTED, String.format("Unsupported column type %s", type.getDisplayName()));
        }

        private TpchColumn<E> getTpchColumn(int field) {
            return this.columns.get(field);
        }
    }
}

