/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpch;

import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorContext;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorNodePartitioningProvider;
import com.facebook.presto.spi.connector.ConnectorRecordSetProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.transaction.IsolationLevel;
import com.facebook.presto.tpch.ColumnNaming;
import com.facebook.presto.tpch.TpchHandleResolver;
import com.facebook.presto.tpch.TpchMetadata;
import com.facebook.presto.tpch.TpchNodePartitioningProvider;
import com.facebook.presto.tpch.TpchRecordSetProvider;
import com.facebook.presto.tpch.TpchSplitManager;
import com.facebook.presto.tpch.TpchTransactionHandle;
import com.google.common.base.MoreObjects;
import java.util.Map;

public class TpchConnectorFactory
implements ConnectorFactory {
    public static final boolean DEFAULT_PREDICATE_PUSHDOWN_ENABLED = false;
    private final int defaultSplitsPerNode;
    private final boolean defaultPredicatePushdownEnabled;

    public TpchConnectorFactory() {
        this(Runtime.getRuntime().availableProcessors(), false);
    }

    public TpchConnectorFactory(int defaultSplitsPerNode) {
        this(defaultSplitsPerNode, false);
    }

    public TpchConnectorFactory(int defaultSplitsPerNode, boolean defaultPredicatePushdownEnabled) {
        this.defaultSplitsPerNode = defaultSplitsPerNode;
        this.defaultPredicatePushdownEnabled = defaultPredicatePushdownEnabled;
    }

    public String getName() {
        return "tpch";
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new TpchHandleResolver();
    }

    public Connector create(final String connectorId, Map<String, String> properties, ConnectorContext context) {
        final int splitsPerNode = this.getSplitsPerNode(properties);
        final boolean predicatePushdownEnabled = this.isPredicatePushdownEnabled(properties);
        final ColumnNaming columnNaming = ColumnNaming.valueOf(properties.getOrDefault("tpch.column-naming", ColumnNaming.SIMPLIFIED.name()).toUpperCase());
        final NodeManager nodeManager = context.getNodeManager();
        return new Connector(){

            public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
                return TpchTransactionHandle.INSTANCE;
            }

            public ConnectorMetadata getMetadata(ConnectorTransactionHandle transaction) {
                return new TpchMetadata(connectorId, predicatePushdownEnabled, columnNaming);
            }

            public ConnectorSplitManager getSplitManager() {
                return new TpchSplitManager(nodeManager, splitsPerNode);
            }

            public ConnectorRecordSetProvider getRecordSetProvider() {
                return new TpchRecordSetProvider();
            }

            public ConnectorNodePartitioningProvider getNodePartitioningProvider() {
                return new TpchNodePartitioningProvider(nodeManager, splitsPerNode);
            }
        };
    }

    private int getSplitsPerNode(Map<String, String> properties) {
        try {
            return Integer.parseInt((String)MoreObjects.firstNonNull((Object)properties.get("tpch.splits-per-node"), (Object)String.valueOf(this.defaultSplitsPerNode)));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid property tpch.splits-per-node");
        }
    }

    private boolean isPredicatePushdownEnabled(Map<String, String> properties) {
        return Boolean.parseBoolean((String)MoreObjects.firstNonNull((Object)properties.get("tpch.predicate-pushdown"), (Object)String.valueOf(this.defaultPredicatePushdownEnabled)));
    }
}

