/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpch;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ColumnMetadata;
import com.facebook.presto.spi.ConnectorNodePartitioning;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayout;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.ConnectorTableLayoutResult;
import com.facebook.presto.spi.ConnectorTableMetadata;
import com.facebook.presto.spi.Constraint;
import com.facebook.presto.spi.SchemaTableName;
import com.facebook.presto.spi.SchemaTablePrefix;
import com.facebook.presto.spi.SortingProperty;
import com.facebook.presto.spi.block.SortOrder;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorPartitioningHandle;
import com.facebook.presto.spi.predicate.TupleDomain;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.DateType;
import com.facebook.presto.spi.type.DoubleType;
import com.facebook.presto.spi.type.IntegerType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.spi.type.VarcharType;
import com.facebook.presto.tpch.ColumnNaming;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchPartitioningHandle;
import com.facebook.presto.tpch.TpchTableHandle;
import com.facebook.presto.tpch.TpchTableLayoutHandle;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableSet;
import io.airlift.tpch.LineItemColumn;
import io.airlift.tpch.OrderColumn;
import io.airlift.tpch.TpchColumn;
import io.airlift.tpch.TpchColumnType;
import io.airlift.tpch.TpchEntity;
import io.airlift.tpch.TpchTable;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;

public class TpchMetadata
implements ConnectorMetadata {
    public static final String TINY_SCHEMA_NAME = "tiny";
    public static final double TINY_SCALE_FACTOR = 0.01;
    public static final List<String> SCHEMA_NAMES = ImmutableList.of((Object)"tiny", (Object)"sf1", (Object)"sf100", (Object)"sf300", (Object)"sf1000", (Object)"sf3000", (Object)"sf10000", (Object)"sf30000", (Object)"sf100000");
    public static final String ROW_NUMBER_COLUMN_NAME = "row_number";
    private final String connectorId;
    private final Set<String> tableNames;
    private final ColumnNaming columnNaming;

    public TpchMetadata(String connectorId) {
        this(connectorId, ColumnNaming.SIMPLIFIED);
    }

    public TpchMetadata(String connectorId, ColumnNaming columnNaming) {
        ImmutableSet.Builder tableNames = ImmutableSet.builder();
        for (TpchTable tpchTable : TpchTable.getTables()) {
            tableNames.add((Object)tpchTable.getTableName());
        }
        this.tableNames = tableNames.build();
        this.connectorId = connectorId;
        this.columnNaming = columnNaming;
    }

    public List<String> listSchemaNames(ConnectorSession session) {
        return SCHEMA_NAMES;
    }

    public TpchTableHandle getTableHandle(ConnectorSession session, SchemaTableName tableName) {
        Objects.requireNonNull(tableName, "tableName is null");
        if (!this.tableNames.contains(tableName.getTableName())) {
            return null;
        }
        double scaleFactor = TpchMetadata.schemaNameToScaleFactor(tableName.getSchemaName());
        if (scaleFactor < 0.0) {
            return null;
        }
        return new TpchTableHandle(this.connectorId, tableName.getTableName(), scaleFactor);
    }

    public List<ConnectorTableLayoutResult> getTableLayouts(ConnectorSession session, ConnectorTableHandle table, Constraint<ColumnHandle> constraint, Optional<Set<ColumnHandle>> desiredColumns) {
        ColumnHandle orderKeyColumn;
        TpchTableHandle tableHandle = (TpchTableHandle)table;
        Optional<Object> nodePartition = Optional.empty();
        Optional<Object> partitioningColumns = Optional.empty();
        ImmutableList localProperties = ImmutableList.of();
        Map<String, ColumnHandle> columns = this.getColumnHandles(session, tableHandle);
        if (tableHandle.getTableName().equals(TpchTable.ORDERS.getTableName())) {
            orderKeyColumn = columns.get(this.columnNaming.getName((TpchColumn<? extends TpchEntity>)OrderColumn.ORDER_KEY));
            nodePartition = Optional.of(new ConnectorNodePartitioning((ConnectorPartitioningHandle)new TpchPartitioningHandle(TpchTable.ORDERS.getTableName(), this.calculateTotalRows(1500000, tableHandle.getScaleFactor())), (List)ImmutableList.of((Object)orderKeyColumn)));
            partitioningColumns = Optional.of(ImmutableSet.of((Object)orderKeyColumn));
            localProperties = ImmutableList.of((Object)new SortingProperty((Object)orderKeyColumn, SortOrder.ASC_NULLS_FIRST));
        } else if (tableHandle.getTableName().equals(TpchTable.LINE_ITEM.getTableName())) {
            orderKeyColumn = columns.get(this.columnNaming.getName((TpchColumn<? extends TpchEntity>)LineItemColumn.ORDER_KEY));
            nodePartition = Optional.of(new ConnectorNodePartitioning((ConnectorPartitioningHandle)new TpchPartitioningHandle(TpchTable.ORDERS.getTableName(), this.calculateTotalRows(1500000, tableHandle.getScaleFactor())), (List)ImmutableList.of((Object)orderKeyColumn)));
            partitioningColumns = Optional.of(ImmutableSet.of((Object)orderKeyColumn));
            localProperties = ImmutableList.of((Object)new SortingProperty((Object)orderKeyColumn, SortOrder.ASC_NULLS_FIRST), (Object)new SortingProperty((Object)columns.get(this.columnNaming.getName((TpchColumn<? extends TpchEntity>)LineItemColumn.LINE_NUMBER)), SortOrder.ASC_NULLS_FIRST));
        }
        ConnectorTableLayout layout = new ConnectorTableLayout((ConnectorTableLayoutHandle)new TpchTableLayoutHandle(tableHandle), Optional.empty(), TupleDomain.all(), nodePartition, partitioningColumns, Optional.empty(), (List)localProperties);
        return ImmutableList.of((Object)new ConnectorTableLayoutResult(layout, constraint.getSummary()));
    }

    public ConnectorTableLayout getTableLayout(ConnectorSession session, ConnectorTableLayoutHandle handle) {
        TpchTableLayoutHandle layout = (TpchTableLayoutHandle)handle;
        return this.getTableLayouts(session, layout.getTable(), (Constraint<ColumnHandle>)Constraint.alwaysTrue(), Optional.empty()).get(0).getTableLayout();
    }

    public ConnectorTableMetadata getTableMetadata(ConnectorSession session, ConnectorTableHandle tableHandle) {
        TpchTableHandle tpchTableHandle = (TpchTableHandle)tableHandle;
        TpchTable tpchTable = TpchTable.getTable((String)tpchTableHandle.getTableName());
        String schemaName = TpchMetadata.scaleFactorSchemaName(tpchTableHandle.getScaleFactor());
        return TpchMetadata.getTableMetadata(schemaName, tpchTable, this.columnNaming);
    }

    private static ConnectorTableMetadata getTableMetadata(String schemaName, TpchTable<?> tpchTable, ColumnNaming columnNaming) {
        ImmutableList.Builder columns = ImmutableList.builder();
        for (TpchColumn column : tpchTable.getColumns()) {
            columns.add((Object)new ColumnMetadata(columnNaming.getName((TpchColumn<? extends TpchEntity>)column), TpchMetadata.getPrestoType(column.getType())));
        }
        columns.add((Object)new ColumnMetadata(ROW_NUMBER_COLUMN_NAME, (Type)BigintType.BIGINT, null, true));
        SchemaTableName tableName = new SchemaTableName(schemaName, tpchTable.getTableName());
        return new ConnectorTableMetadata(tableName, (List)columns.build());
    }

    public Map<String, ColumnHandle> getColumnHandles(ConnectorSession session, ConnectorTableHandle tableHandle) {
        ImmutableMap.Builder builder = ImmutableMap.builder();
        for (ColumnMetadata columnMetadata : this.getTableMetadata(session, tableHandle).getColumns()) {
            builder.put((Object)columnMetadata.getName(), (Object)new TpchColumnHandle(columnMetadata.getName(), columnMetadata.getType()));
        }
        return builder.build();
    }

    public Map<SchemaTableName, List<ColumnMetadata>> listTableColumns(ConnectorSession session, SchemaTablePrefix prefix) {
        ImmutableMap.Builder tableColumns = ImmutableMap.builder();
        for (String schemaName : this.getSchemaNames(session, prefix.getSchemaName())) {
            for (TpchTable tpchTable : TpchTable.getTables()) {
                if (prefix.getTableName() != null && !tpchTable.getTableName().equals(prefix.getTableName())) continue;
                ConnectorTableMetadata tableMetadata = TpchMetadata.getTableMetadata(schemaName, tpchTable, this.columnNaming);
                tableColumns.put((Object)new SchemaTableName(schemaName, tpchTable.getTableName()), (Object)tableMetadata.getColumns());
            }
        }
        return tableColumns.build();
    }

    public ColumnMetadata getColumnMetadata(ConnectorSession session, ConnectorTableHandle tableHandle, ColumnHandle columnHandle) {
        ConnectorTableMetadata tableMetadata = this.getTableMetadata(session, tableHandle);
        String columnName = ((TpchColumnHandle)columnHandle).getColumnName();
        for (ColumnMetadata column : tableMetadata.getColumns()) {
            if (!column.getName().equals(columnName)) continue;
            return column;
        }
        throw new IllegalArgumentException(String.format("Table %s does not have column %s", tableMetadata.getTable(), columnName));
    }

    public List<SchemaTableName> listTables(ConnectorSession session, String schemaNameOrNull) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String schemaName : this.getSchemaNames(session, schemaNameOrNull)) {
            for (TpchTable tpchTable : TpchTable.getTables()) {
                builder.add((Object)new SchemaTableName(schemaName, tpchTable.getTableName()));
            }
        }
        return builder.build();
    }

    private List<String> getSchemaNames(ConnectorSession session, String schemaNameOrNull) {
        ImmutableList schemaNames = schemaNameOrNull == null ? this.listSchemaNames(session) : (TpchMetadata.schemaNameToScaleFactor(schemaNameOrNull) > 0.0 ? ImmutableList.of((Object)schemaNameOrNull) : ImmutableList.of());
        return schemaNames;
    }

    private static String scaleFactorSchemaName(double scaleFactor) {
        return "sf" + scaleFactor;
    }

    private static double schemaNameToScaleFactor(String schemaName) {
        if (TINY_SCHEMA_NAME.equals(schemaName)) {
            return 0.01;
        }
        if (!schemaName.startsWith("sf")) {
            return -1.0;
        }
        try {
            return Double.parseDouble(schemaName.substring(2));
        }
        catch (Exception ignored) {
            return -1.0;
        }
    }

    public static Type getPrestoType(TpchColumnType tpchType) {
        switch (tpchType.getBase()) {
            case IDENTIFIER: {
                return BigintType.BIGINT;
            }
            case INTEGER: {
                return IntegerType.INTEGER;
            }
            case DATE: {
                return DateType.DATE;
            }
            case DOUBLE: {
                return DoubleType.DOUBLE;
            }
            case VARCHAR: {
                return VarcharType.createVarcharType((int)((int)((Long)tpchType.getPrecision().get()).longValue()));
            }
        }
        throw new IllegalArgumentException("Unsupported type " + tpchType);
    }

    private long calculateTotalRows(int scaleBase, double scaleFactor) {
        double totalRows = (double)scaleBase * scaleFactor;
        if (totalRows > 9.223372036854776E18) {
            throw new IllegalArgumentException("Total rows is larger than 2^64");
        }
        return (long)totalRows;
    }
}

