/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpch.testing;

import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.spi.connector.Connector;
import com.facebook.presto.spi.connector.ConnectorContext;
import com.facebook.presto.spi.connector.ConnectorFactory;
import com.facebook.presto.spi.connector.ConnectorMetadata;
import com.facebook.presto.spi.connector.ConnectorNodePartitioningProvider;
import com.facebook.presto.spi.connector.ConnectorRecordSetProvider;
import com.facebook.presto.spi.connector.ConnectorSplitManager;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.transaction.IsolationLevel;
import com.facebook.presto.tpch.TpchHandleResolver;
import com.facebook.presto.tpch.TpchNodePartitioningProvider;
import com.facebook.presto.tpch.TpchSplitManager;
import com.facebook.presto.tpch.TpchTransactionHandle;
import com.facebook.presto.tpch.testing.SampledTpchMetadata;
import com.facebook.presto.tpch.testing.SampledTpchRecordSetProvider;
import com.google.common.base.MoreObjects;
import java.util.Map;
import java.util.Objects;

public class SampledTpchConnectorFactory
implements ConnectorFactory {
    private final NodeManager nodeManager;
    private final int defaultSplitsPerNode;
    private final int sampleWeight;

    public SampledTpchConnectorFactory(NodeManager nodeManager, int defaultSplitsPerNode, int sampleWeight) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.defaultSplitsPerNode = defaultSplitsPerNode;
        this.sampleWeight = sampleWeight;
    }

    public String getName() {
        return "tpch_sampled";
    }

    public ConnectorHandleResolver getHandleResolver() {
        return new TpchHandleResolver();
    }

    public Connector create(final String connectorId, Map<String, String> properties, ConnectorContext context) {
        Objects.requireNonNull(properties, "properties is null");
        final int splitsPerNode = this.getSplitsPerNode(properties);
        return new Connector(){

            public ConnectorTransactionHandle beginTransaction(IsolationLevel isolationLevel, boolean readOnly) {
                return TpchTransactionHandle.INSTANCE;
            }

            public ConnectorMetadata getMetadata(ConnectorTransactionHandle transaction) {
                return new SampledTpchMetadata(connectorId);
            }

            public ConnectorSplitManager getSplitManager() {
                return new TpchSplitManager(connectorId, SampledTpchConnectorFactory.this.nodeManager, splitsPerNode);
            }

            public ConnectorRecordSetProvider getRecordSetProvider() {
                return new SampledTpchRecordSetProvider(connectorId, SampledTpchConnectorFactory.this.sampleWeight);
            }

            public ConnectorNodePartitioningProvider getNodePartitioningProvider() {
                return new TpchNodePartitioningProvider(connectorId, SampledTpchConnectorFactory.this.nodeManager, splitsPerNode);
            }
        };
    }

    private int getSplitsPerNode(Map<String, String> properties) {
        try {
            return Integer.parseInt((String)MoreObjects.firstNonNull((Object)properties.get("tpch.splits-per-node"), (Object)String.valueOf(this.defaultSplitsPerNode)));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid property tpch.splits-per-node");
        }
    }
}

