/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpch;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.connector.ConnectorRecordSetProvider;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchRecordSet;
import com.facebook.presto.tpch.TpchSplit;
import com.facebook.presto.tpch.Types;
import com.google.common.collect.ImmutableList;
import io.airlift.tpch.TpchColumn;
import io.airlift.tpch.TpchColumnType;
import io.airlift.tpch.TpchColumnTypes;
import io.airlift.tpch.TpchEntity;
import io.airlift.tpch.TpchTable;
import java.util.List;

public class TpchRecordSetProvider
implements ConnectorRecordSetProvider {
    public RecordSet getRecordSet(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, List<? extends ColumnHandle> columns) {
        TpchSplit tpchSplit = Types.checkType(split, TpchSplit.class, "split");
        String tableName = tpchSplit.getTableHandle().getTableName();
        TpchTable tpchTable = TpchTable.getTable((String)tableName);
        return this.getRecordSet(tpchTable, columns, tpchSplit.getTableHandle().getScaleFactor(), tpchSplit.getPartNumber(), tpchSplit.getTotalParts());
    }

    public <E extends TpchEntity> RecordSet getRecordSet(TpchTable<E> table, List<? extends ColumnHandle> columns, double scaleFactor, int partNumber, int totalParts) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (ColumnHandle columnHandle : columns) {
            String columnName = Types.checkType(columnHandle, TpchColumnHandle.class, "column").getColumnName();
            if (columnName.equalsIgnoreCase("row_number")) {
                builder.add(new RowNumberTpchColumn());
                continue;
            }
            builder.add((Object)table.getColumn(columnName));
        }
        return TpchRecordSet.createTpchRecordSet(table, builder.build(), scaleFactor, partNumber + 1, totalParts);
    }

    private static class RowNumberTpchColumn<E extends TpchEntity>
    implements TpchColumn<E> {
        private RowNumberTpchColumn() {
        }

        public String getColumnName() {
            throw new UnsupportedOperationException();
        }

        public TpchColumnType getType() {
            return TpchColumnTypes.IDENTIFIER;
        }

        public double getDouble(E entity) {
            throw new UnsupportedOperationException();
        }

        public long getIdentifier(E entity) {
            return entity.getRowNumber();
        }

        public int getInteger(E entity) {
            throw new UnsupportedOperationException();
        }

        public String getString(E entity) {
            throw new UnsupportedOperationException();
        }

        public int getDate(E entity) {
            throw new UnsupportedOperationException();
        }
    }
}

