/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpch.testing;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.connector.ConnectorTransactionHandle;
import com.facebook.presto.spi.type.BigintType;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchMetadata;
import com.facebook.presto.tpch.TpchRecordSetProvider;
import com.facebook.presto.tpch.TpchSplit;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class SampledTpchRecordSetProvider
extends TpchRecordSetProvider {
    private final TpchMetadata metadata;
    private final int sampleWeight;

    public SampledTpchRecordSetProvider(String connectorId, int sampleWeight) {
        this.metadata = new TpchMetadata(connectorId);
        this.sampleWeight = sampleWeight;
    }

    @Override
    public RecordSet getRecordSet(ConnectorTransactionHandle transaction, ConnectorSession session, ConnectorSplit split, List<? extends ColumnHandle> columns) {
        int sampleWeightField = -1;
        for (int i = 0; i < columns.size(); ++i) {
            ColumnHandle column = columns.get(i);
            if (!(column instanceof TpchColumnHandle) || !((TpchColumnHandle)column).getColumnName().equals("$sampleWeight")) continue;
            sampleWeightField = i;
            break;
        }
        ArrayList<? extends ColumnHandle> delegatedColumns = new ArrayList<ColumnHandle>(columns);
        if (sampleWeightField > -1) {
            RecordSet recordSet;
            delegatedColumns.remove(sampleWeightField);
            if (delegatedColumns.isEmpty()) {
                TpchSplit tpchSplit = (TpchSplit)split;
                ColumnHandle column = (ColumnHandle)Iterables.getFirst(this.metadata.getColumnHandles(session, tpchSplit.getTableHandle()).values(), null);
                Objects.requireNonNull(column, "Could not find any columns");
                recordSet = new EmptyRecordSet(super.getRecordSet(transaction, session, split, (List<? extends ColumnHandle>)ImmutableList.of((Object)column)));
            } else {
                recordSet = super.getRecordSet(transaction, session, split, delegatedColumns);
            }
            return new SampledTpchRecordSet(recordSet, sampleWeightField, this.sampleWeight);
        }
        return super.getRecordSet(transaction, session, split, columns);
    }

    private static class SampledTpchRecordCursor
    implements RecordCursor {
        private final RecordCursor delegate;
        private final int sampleWeightField;
        private final int sampleWeight;

        public SampledTpchRecordCursor(RecordCursor delegate, int sampleWeightField, int sampleWeight) {
            this.delegate = delegate;
            this.sampleWeightField = sampleWeightField;
            this.sampleWeight = sampleWeight;
        }

        public boolean isNull(int field) {
            if (field == this.sampleWeightField) {
                return false;
            }
            return this.delegate.isNull(field);
        }

        public void close() {
            this.delegate.close();
        }

        public long getLong(int field) {
            if (field == this.sampleWeightField) {
                return this.sampleWeight;
            }
            return this.delegate.getLong(field);
        }

        public double getDouble(int field) {
            return this.delegate.getDouble(field);
        }

        public Slice getSlice(int field) {
            return this.delegate.getSlice(field);
        }

        public Object getObject(int field) {
            return this.delegate.getObject(field);
        }

        public long getTotalBytes() {
            return this.delegate.getTotalBytes();
        }

        public long getCompletedBytes() {
            return this.delegate.getCompletedBytes();
        }

        public long getReadTimeNanos() {
            return 0L;
        }

        public Type getType(int field) {
            if (field == this.sampleWeightField) {
                return BigintType.BIGINT;
            }
            return this.delegate.getType(field);
        }

        public boolean advanceNextPosition() {
            return this.delegate.advanceNextPosition();
        }

        public boolean getBoolean(int field) {
            return this.delegate.getBoolean(field);
        }
    }

    private static class SampledTpchRecordSet
    implements RecordSet {
        private final RecordSet delegate;
        private final int sampleWeightField;
        private final int sampleWeight;

        SampledTpchRecordSet(RecordSet delegate, int sampleWeightField, int sampleWeight) {
            this.delegate = delegate;
            this.sampleWeightField = sampleWeightField;
            this.sampleWeight = sampleWeight;
        }

        public List<Type> getColumnTypes() {
            ArrayList<BigintType> types = new ArrayList<BigintType>();
            types.addAll(this.delegate.getColumnTypes());
            types.add(this.sampleWeightField, BigintType.BIGINT);
            return ImmutableList.copyOf(types);
        }

        public RecordCursor cursor() {
            return new SampledTpchRecordCursor(this.delegate.cursor(), this.sampleWeightField, this.sampleWeight);
        }
    }

    private static class EmptyRecordCursor
    implements RecordCursor {
        private final RecordCursor delegate;

        EmptyRecordCursor(RecordCursor delegate) {
            this.delegate = delegate;
        }

        public long getTotalBytes() {
            return 0L;
        }

        public long getCompletedBytes() {
            return 0L;
        }

        public long getReadTimeNanos() {
            return 0L;
        }

        public Type getType(int field) {
            throw new RuntimeException("record cursor is empty");
        }

        public boolean advanceNextPosition() {
            return this.delegate.advanceNextPosition();
        }

        public boolean getBoolean(int field) {
            throw new RuntimeException("record cursor is empty");
        }

        public long getLong(int field) {
            throw new RuntimeException("record cursor is empty");
        }

        public double getDouble(int field) {
            throw new RuntimeException("record cursor is empty");
        }

        public Slice getSlice(int field) {
            throw new RuntimeException("record cursor is empty");
        }

        public Object getObject(int field) {
            throw new RuntimeException("record cursor is empty");
        }

        public boolean isNull(int field) {
            throw new RuntimeException("record cursor is empty");
        }

        public void close() {
        }
    }

    private static class EmptyRecordSet
    implements RecordSet {
        private final RecordSet delegate;

        EmptyRecordSet(RecordSet delegate) {
            this.delegate = delegate;
        }

        public List<Type> getColumnTypes() {
            return ImmutableList.of();
        }

        public RecordCursor cursor() {
            return new EmptyRecordCursor(this.delegate.cursor());
        }
    }
}

