/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpch;

import com.facebook.presto.spi.BucketFunction;
import com.facebook.presto.spi.Page;
import com.facebook.presto.spi.block.Block;
import com.facebook.presto.spi.type.BigintType;
import com.google.common.base.MoreObjects;
import com.google.common.primitives.Ints;

public class TpchBucketFunction
implements BucketFunction {
    private final int bucketCount;
    private final long rowsPerBucket;

    public TpchBucketFunction(int bucketCount, long rowsPerBucket) {
        this.bucketCount = bucketCount;
        this.rowsPerBucket = rowsPerBucket;
    }

    public int getBucket(Page page, int position) {
        Block block = page.getBlock(0);
        if (block.isNull(position)) {
            return 0;
        }
        long orderKey = BigintType.BIGINT.getLong(block, position);
        long rowNumber = TpchBucketFunction.rowNumberFromOrderKey(orderKey);
        int bucket = Ints.checkedCast((long)(rowNumber / this.rowsPerBucket));
        if (bucket >= this.bucketCount) {
            bucket = this.bucketCount - 1;
        }
        return bucket;
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("bucketCount", this.bucketCount).add("rowsPerBucket", this.rowsPerBucket).toString();
    }

    private static long rowNumberFromOrderKey(long orderKey) {
        return ((orderKey & 0xFFFFFFFFFFFFFFE0L) >>> 2 | orderKey & 7L) - 1L;
    }
}

