/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpch;

import com.facebook.presto.spi.ConnectorSession;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.ConnectorSplitSource;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.spi.FixedSplitSource;
import com.facebook.presto.spi.HostAddress;
import com.facebook.presto.spi.Node;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.tpch.TpchSplit;
import com.facebook.presto.tpch.TpchTableHandle;
import com.facebook.presto.tpch.TpchTableLayoutHandle;
import com.facebook.presto.tpch.Types;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import java.util.List;
import java.util.Set;

public class TpchSplitManager
implements ConnectorSplitManager {
    private final String connectorId;
    private final NodeManager nodeManager;
    private final int splitsPerNode;

    public TpchSplitManager(String connectorId, NodeManager nodeManager, int splitsPerNode) {
        this.connectorId = connectorId;
        this.nodeManager = nodeManager;
        Preconditions.checkArgument((splitsPerNode > 0 ? 1 : 0) != 0, (Object)"splitsPerNode must be at least 1");
        this.splitsPerNode = splitsPerNode;
    }

    public ConnectorSplitSource getSplits(ConnectorSession session, ConnectorTableLayoutHandle layout) {
        TpchTableHandle tableHandle = Types.checkType(layout, TpchTableLayoutHandle.class, "layout").getTable();
        Set nodes = this.nodeManager.getActiveDatasourceNodes(this.connectorId);
        Preconditions.checkState((!nodes.isEmpty() ? 1 : 0) != 0, (Object)"No TPCH nodes available");
        int totalParts = nodes.size() * this.splitsPerNode;
        int partNumber = 0;
        ImmutableList.Builder splits = ImmutableList.builder();
        for (Node node : nodes) {
            for (int i = 0; i < this.splitsPerNode; ++i) {
                splits.add((Object)new TpchSplit(tableHandle, partNumber, totalParts, (List<HostAddress>)ImmutableList.of((Object)node.getHostAndPort())));
                ++partNumber;
            }
        }
        return new FixedSplitSource(this.connectorId, (Iterable)splits.build());
    }
}

