/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpch.testing;

import com.facebook.presto.spi.Connector;
import com.facebook.presto.spi.ConnectorFactory;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorMetadata;
import com.facebook.presto.spi.ConnectorRecordSetProvider;
import com.facebook.presto.spi.ConnectorSplitManager;
import com.facebook.presto.spi.NodeManager;
import com.facebook.presto.tpch.TpchHandleResolver;
import com.facebook.presto.tpch.TpchSplitManager;
import com.facebook.presto.tpch.testing.SampledTpchMetadata;
import com.facebook.presto.tpch.testing.SampledTpchRecordSetProvider;
import com.google.common.base.MoreObjects;
import java.util.Map;
import java.util.Objects;

public class SampledTpchConnectorFactory
implements ConnectorFactory {
    private final NodeManager nodeManager;
    private final int defaultSplitsPerNode;
    private final int sampleWeight;

    public SampledTpchConnectorFactory(NodeManager nodeManager, int defaultSplitsPerNode, int sampleWeight) {
        this.nodeManager = Objects.requireNonNull(nodeManager, "nodeManager is null");
        this.defaultSplitsPerNode = defaultSplitsPerNode;
        this.sampleWeight = sampleWeight;
    }

    public String getName() {
        return "tpch_sampled";
    }

    public Connector create(final String connectorId, Map<String, String> properties) {
        Objects.requireNonNull(properties, "properties is null");
        final int splitsPerNode = this.getSplitsPerNode(properties);
        return new Connector(){

            public ConnectorMetadata getMetadata() {
                return new SampledTpchMetadata(connectorId);
            }

            public ConnectorSplitManager getSplitManager() {
                return new TpchSplitManager(connectorId, SampledTpchConnectorFactory.this.nodeManager, splitsPerNode);
            }

            public ConnectorHandleResolver getHandleResolver() {
                return new TpchHandleResolver(connectorId);
            }

            public ConnectorRecordSetProvider getRecordSetProvider() {
                return new SampledTpchRecordSetProvider(connectorId, SampledTpchConnectorFactory.this.sampleWeight);
            }
        };
    }

    private int getSplitsPerNode(Map<String, String> properties) {
        try {
            return Integer.parseInt((String)MoreObjects.firstNonNull((Object)properties.get("tpch.splits-per-node"), (Object)String.valueOf(this.defaultSplitsPerNode)));
        }
        catch (NumberFormatException e) {
            throw new IllegalArgumentException("Invalid property tpch.splits-per-node");
        }
    }
}

