/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpch;

import com.facebook.presto.spi.ColumnHandle;
import com.facebook.presto.spi.ConnectorHandleResolver;
import com.facebook.presto.spi.ConnectorSplit;
import com.facebook.presto.spi.ConnectorTableHandle;
import com.facebook.presto.spi.ConnectorTableLayoutHandle;
import com.facebook.presto.tpch.TpchColumnHandle;
import com.facebook.presto.tpch.TpchSplit;
import com.facebook.presto.tpch.TpchTableHandle;
import com.facebook.presto.tpch.TpchTableLayoutHandle;
import java.util.Objects;

public class TpchHandleResolver
implements ConnectorHandleResolver {
    private final String connectorId;

    public TpchHandleResolver(String connectorId) {
        this.connectorId = Objects.requireNonNull(connectorId, "connectorId is null");
    }

    public boolean canHandle(ConnectorTableHandle tableHandle) {
        return tableHandle instanceof TpchTableHandle && ((TpchTableHandle)tableHandle).getConnectorId().equals(this.connectorId);
    }

    public boolean canHandle(ConnectorTableLayoutHandle handle) {
        return handle instanceof TpchTableLayoutHandle && ((TpchTableLayoutHandle)handle).getConnectorId().equals(this.connectorId);
    }

    public boolean canHandle(ColumnHandle columnHandle) {
        return columnHandle instanceof TpchColumnHandle;
    }

    public boolean canHandle(ConnectorSplit split) {
        return split instanceof TpchSplit && ((TpchSplit)split).getTableHandle().getConnectorId().equals(this.connectorId);
    }

    public Class<? extends ConnectorTableHandle> getTableHandleClass() {
        return TpchTableHandle.class;
    }

    public Class<? extends ColumnHandle> getColumnHandleClass() {
        return TpchColumnHandle.class;
    }

    public Class<? extends ConnectorSplit> getSplitClass() {
        return TpchSplit.class;
    }

    public Class<? extends ConnectorTableLayoutHandle> getTableLayoutHandleClass() {
        return TpchTableLayoutHandle.class;
    }
}

