/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.tpch;

import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.spi.type.Type;
import com.facebook.presto.tpch.TpchMetadata;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Iterables;
import io.airlift.slice.Slice;
import io.airlift.slice.Slices;
import io.airlift.tpch.TpchColumn;
import io.airlift.tpch.TpchColumnType;
import io.airlift.tpch.TpchEntity;
import io.airlift.tpch.TpchTable;
import java.util.Iterator;
import java.util.List;

public class TpchRecordSet<E extends TpchEntity>
implements RecordSet {
    private final Iterable<E> table;
    private final List<TpchColumn<E>> columns;
    private final List<Type> columnTypes;

    public static <E extends TpchEntity> TpchRecordSet<E> createTpchRecordSet(TpchTable<E> table, double scaleFactor) {
        return TpchRecordSet.createTpchRecordSet(table, table.getColumns(), scaleFactor, 1, 1);
    }

    public static <E extends TpchEntity> TpchRecordSet<E> createTpchRecordSet(TpchTable<E> table, Iterable<TpchColumn<E>> columns, double scaleFactor, int part, int partCount) {
        return new TpchRecordSet<E>(table.createGenerator(scaleFactor, part, partCount), columns);
    }

    public TpchRecordSet(Iterable<E> table, Iterable<TpchColumn<E>> columns) {
        Preconditions.checkNotNull(table, (Object)"readerSupplier is null");
        this.table = table;
        this.columns = ImmutableList.copyOf(columns);
        this.columnTypes = ImmutableList.copyOf((Iterable)Iterables.transform(columns, column -> TpchMetadata.getPrestoType(column.getType())));
    }

    public List<Type> getColumnTypes() {
        return this.columnTypes;
    }

    public RecordCursor cursor() {
        return new TpchRecordCursor<E>(this.table.iterator(), this.columns);
    }

    public class TpchRecordCursor<E extends TpchEntity>
    implements RecordCursor {
        private final Iterator<E> rows;
        private final List<TpchColumn<E>> columns;
        private E row;
        private boolean closed;

        public TpchRecordCursor(Iterator<E> rows, List<TpchColumn<E>> columns) {
            this.rows = rows;
            this.columns = columns;
        }

        public long getTotalBytes() {
            return 0L;
        }

        public long getCompletedBytes() {
            return 0L;
        }

        public long getReadTimeNanos() {
            return 0L;
        }

        public Type getType(int field) {
            return TpchMetadata.getPrestoType(this.getTpchColumn(field).getType());
        }

        public boolean advanceNextPosition() {
            if (this.closed || !this.rows.hasNext()) {
                this.closed = true;
                this.row = null;
                return false;
            }
            this.row = (TpchEntity)this.rows.next();
            return true;
        }

        public boolean getBoolean(int field) {
            throw new UnsupportedOperationException();
        }

        public long getLong(int field) {
            Preconditions.checkState((this.row != null ? 1 : 0) != 0, (Object)"No current row");
            TpchColumn<E> tpchColumn = this.getTpchColumn(field);
            if (tpchColumn.getType() == TpchColumnType.DATE) {
                return tpchColumn.getDate(this.row);
            }
            return tpchColumn.getLong(this.row);
        }

        public double getDouble(int field) {
            Preconditions.checkState((this.row != null ? 1 : 0) != 0, (Object)"No current row");
            return this.getTpchColumn(field).getDouble(this.row);
        }

        public Slice getSlice(int field) {
            Preconditions.checkState((this.row != null ? 1 : 0) != 0, (Object)"No current row");
            return Slices.utf8Slice((String)this.getTpchColumn(field).getString(this.row));
        }

        public boolean isNull(int field) {
            return false;
        }

        public void close() {
            this.row = null;
            this.closed = true;
        }

        private TpchColumn<E> getTpchColumn(int field) {
            return this.columns.get(field);
        }
    }
}

