/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.connector.thrift.server;

import com.facebook.presto.common.type.Type;
import com.facebook.presto.connector.thrift.server.ListBasedRecordSet;
import com.facebook.presto.connector.thrift.server.SplitInfo;
import com.facebook.presto.connector.thrift.server.ThriftTpchService;
import com.facebook.presto.spi.ConnectorPageSource;
import com.facebook.presto.spi.RecordPageSource;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.split.MappedRecordSet;
import com.facebook.presto.tests.AbstractTestIndexedQueries;
import com.facebook.presto.tests.tpch.TpchIndexedData;
import com.facebook.presto.tests.tpch.TpchScaledTable;
import com.facebook.presto.thrift.api.connector.PrestoThriftId;
import com.facebook.presto.thrift.api.connector.PrestoThriftNullableToken;
import com.facebook.presto.thrift.api.connector.PrestoThriftPageResult;
import com.facebook.presto.thrift.api.connector.PrestoThriftSchemaTableName;
import com.facebook.presto.thrift.api.connector.PrestoThriftServiceException;
import com.facebook.presto.thrift.api.connector.PrestoThriftSplit;
import com.facebook.presto.thrift.api.connector.PrestoThriftSplitBatch;
import com.facebook.presto.thrift.api.datatypes.PrestoThriftBlock;
import com.google.common.base.Preconditions;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.ImmutableSet;
import java.util.ArrayList;
import java.util.List;
import java.util.Set;

public class ThriftIndexedTpchService
extends ThriftTpchService {
    private static final int NUMBER_OF_INDEX_SPLITS = 2;
    private final TpchIndexedData indexedData = new TpchIndexedData("tpchindexed", AbstractTestIndexedQueries.INDEX_SPEC);

    @Override
    protected List<Set<String>> getIndexableKeys(String schemaName, String tableName) {
        TpchScaledTable tpchScaledTable = new TpchScaledTable(tableName, ThriftIndexedTpchService.schemaNameToScaleFactor(schemaName));
        return ImmutableList.copyOf((Iterable)AbstractTestIndexedQueries.INDEX_SPEC.getColumnIndexes(tpchScaledTable));
    }

    @Override
    protected PrestoThriftSplitBatch getIndexSplitsSync(PrestoThriftSchemaTableName schemaTableName, List<String> indexColumnNames, PrestoThriftPageResult keys, int maxSplitCount, PrestoThriftNullableToken nextToken) throws PrestoThriftServiceException {
        Preconditions.checkArgument((2 <= maxSplitCount ? 1 : 0) != 0, (Object)"maxSplitCount for lookup splits is too low");
        Preconditions.checkArgument((nextToken.getToken() == null ? 1 : 0) != 0, (Object)"no continuation is supported for lookup splits");
        int totalKeys = keys.getRowCount();
        int partSize = totalKeys / 2;
        ArrayList<PrestoThriftSplit> splits = new ArrayList<PrestoThriftSplit>(2);
        for (int splitIndex = 0; splitIndex < 2; ++splitIndex) {
            int begin = partSize * splitIndex;
            int end = partSize * (splitIndex + 1);
            if (splitIndex + 1 == 2) {
                end = totalKeys;
            }
            if (begin == end) continue;
            SplitInfo splitInfo = SplitInfo.indexSplit(schemaTableName.getSchemaName(), schemaTableName.getTableName(), indexColumnNames, ThriftIndexedTpchService.thriftPageToList(keys, begin, end));
            splits.add(new PrestoThriftSplit(new PrestoThriftId(SPLIT_INFO_CODEC.toJsonBytes((Object)splitInfo)), (List)ImmutableList.of()));
        }
        return new PrestoThriftSplitBatch(splits, null);
    }

    @Override
    protected ConnectorPageSource createLookupPageSource(SplitInfo splitInfo, List<String> outputColumnNames) {
        TpchIndexedData.IndexedTable indexedTable = (TpchIndexedData.IndexedTable)this.indexedData.getIndexedTable(splitInfo.getTableName(), ThriftIndexedTpchService.schemaNameToScaleFactor(splitInfo.getSchemaName()), (Set)ImmutableSet.copyOf(splitInfo.getLookupColumnNames())).orElseThrow(() -> new IllegalArgumentException(String.format("No such index: %s%s", splitInfo.getTableName(), splitInfo.getLookupColumnNames())));
        List<Type> lookupColumnTypes = ThriftIndexedTpchService.types(splitInfo.getTableName(), splitInfo.getLookupColumnNames());
        MappedRecordSet keyRecordSet = new MappedRecordSet((RecordSet)new ListBasedRecordSet(splitInfo.getKeys(), lookupColumnTypes), ThriftIndexedTpchService.computeRemap(splitInfo.getLookupColumnNames(), indexedTable.getKeyColumns()));
        RecordSet outputRecordSet = ThriftIndexedTpchService.lookupIndexKeys((RecordSet)keyRecordSet, indexedTable, outputColumnNames);
        return new RecordPageSource(outputRecordSet);
    }

    private static RecordSet lookupIndexKeys(RecordSet keys, TpchIndexedData.IndexedTable table, List<String> outputColumnNames) {
        RecordSet allColumnsOutputRecordSet = table.lookupKeys(keys);
        List<Integer> outputRemap = ThriftIndexedTpchService.computeRemap(table.getOutputColumns(), outputColumnNames);
        return new MappedRecordSet(allColumnsOutputRecordSet, outputRemap);
    }

    private static List<List<String>> thriftPageToList(PrestoThriftPageResult page, int begin, int end) {
        Preconditions.checkArgument((begin <= end ? 1 : 0) != 0, (Object)"invalid interval");
        if (begin == end) {
            return ImmutableList.of();
        }
        List blocks = page.getColumnBlocks();
        ArrayList<List<String>> result = new ArrayList<List<String>>(blocks.size());
        for (PrestoThriftBlock block : blocks) {
            result.add(ThriftIndexedTpchService.blockAsList(block, begin, end));
        }
        return result;
    }

    private static List<String> blockAsList(PrestoThriftBlock block, int begin, int end) {
        ArrayList<String> result = new ArrayList<String>(end - begin);
        if (block.getBigintData() != null) {
            boolean[] nulls = block.getBigintData().getNulls();
            long[] longs = block.getBigintData().getLongs();
            for (int index = begin; index < end; ++index) {
                if (nulls != null && nulls[index]) {
                    result.add(null);
                    continue;
                }
                Preconditions.checkArgument((longs != null ? 1 : 0) != 0, (Object)"block structure is incorrect");
                result.add(String.valueOf(longs[index]));
            }
        } else if (block.getIntegerData() != null) {
            boolean[] nulls = block.getIntegerData().getNulls();
            int[] ints = block.getIntegerData().getInts();
            for (int index = begin; index < end; ++index) {
                if (nulls != null && nulls[index]) {
                    result.add(null);
                    continue;
                }
                Preconditions.checkArgument((ints != null ? 1 : 0) != 0, (Object)"block structure is incorrect");
                result.add(String.valueOf(ints[index]));
            }
        } else if (block.getVarcharData() != null) {
            int index;
            boolean[] nulls = block.getVarcharData().getNulls();
            int[] sizes = block.getVarcharData().getSizes();
            byte[] bytes = block.getVarcharData().getBytes();
            int startOffset = 0;
            if (sizes != null) {
                for (index = 0; index < begin; ++index) {
                    if (nulls != null && nulls[index]) continue;
                    startOffset += sizes[index];
                }
            }
            for (index = begin; index < end; ++index) {
                if (nulls != null && nulls[index]) {
                    result.add(null);
                    continue;
                }
                Preconditions.checkArgument((sizes != null ? 1 : 0) != 0, (Object)"block structure is incorrect");
                if (sizes[index] == 0) {
                    result.add("");
                    continue;
                }
                Preconditions.checkArgument((bytes != null ? 1 : 0) != 0);
                result.add(new String(bytes, startOffset, sizes[index]));
                startOffset += sizes[index];
            }
        } else {
            throw new IllegalArgumentException("Only bigint, integer and varchar blocks are supported");
        }
        return result;
    }

    private static List<Integer> computeRemap(List<String> startSchema, List<String> endSchema) {
        ImmutableList.Builder builder = ImmutableList.builder();
        for (String columnName : endSchema) {
            int index = startSchema.indexOf(columnName);
            Preconditions.checkArgument((index != -1 ? 1 : 0) != 0, (String)"Column name in end that is not in the start: %s", (Object)columnName);
            builder.add((Object)index);
        }
        return builder.build();
    }
}

