/*
 * Decompiled with CFR 0.152.
 */
package com.facebook.presto.thrift.api.datatypes;

import com.facebook.drift.annotations.ThriftConstructor;
import com.facebook.drift.annotations.ThriftField;
import com.facebook.drift.annotations.ThriftStruct;
import com.facebook.presto.common.block.Block;
import com.facebook.presto.common.block.BlockBuilder;
import com.facebook.presto.common.type.BigintType;
import com.facebook.presto.common.type.Type;
import com.facebook.presto.spi.RecordCursor;
import com.facebook.presto.spi.RecordSet;
import com.facebook.presto.thrift.api.datatypes.PrestoThriftBigint;
import com.facebook.presto.thrift.api.datatypes.PrestoThriftBigintArray;
import com.facebook.presto.thrift.api.datatypes.PrestoThriftBoolean;
import com.facebook.presto.thrift.api.datatypes.PrestoThriftColumnData;
import com.facebook.presto.thrift.api.datatypes.PrestoThriftDate;
import com.facebook.presto.thrift.api.datatypes.PrestoThriftDouble;
import com.facebook.presto.thrift.api.datatypes.PrestoThriftHyperLogLog;
import com.facebook.presto.thrift.api.datatypes.PrestoThriftInteger;
import com.facebook.presto.thrift.api.datatypes.PrestoThriftJson;
import com.facebook.presto.thrift.api.datatypes.PrestoThriftTimestamp;
import com.facebook.presto.thrift.api.datatypes.PrestoThriftVarchar;
import com.google.common.base.MoreObjects;
import com.google.common.base.Preconditions;
import com.google.common.collect.MoreCollectors;
import io.airlift.slice.Slice;
import jakarta.annotation.Nullable;
import java.util.Objects;

@ThriftStruct
public final class PrestoThriftBlock {
    private final PrestoThriftInteger integerData;
    private final PrestoThriftBigint bigintData;
    private final PrestoThriftDouble doubleData;
    private final PrestoThriftVarchar varcharData;
    private final PrestoThriftBoolean booleanData;
    private final PrestoThriftDate dateData;
    private final PrestoThriftTimestamp timestampData;
    private final PrestoThriftJson jsonData;
    private final PrestoThriftHyperLogLog hyperLogLogData;
    private final PrestoThriftBigintArray bigintArrayData;
    private final PrestoThriftColumnData dataReference;

    @ThriftConstructor
    public PrestoThriftBlock(@Nullable PrestoThriftInteger integerData, @Nullable PrestoThriftBigint bigintData, @Nullable PrestoThriftDouble doubleData, @Nullable PrestoThriftVarchar varcharData, @Nullable PrestoThriftBoolean booleanData, @Nullable PrestoThriftDate dateData, @Nullable PrestoThriftTimestamp timestampData, @Nullable PrestoThriftJson jsonData, @Nullable PrestoThriftHyperLogLog hyperLogLogData, @Nullable PrestoThriftBigintArray bigintArrayData) {
        this.integerData = integerData;
        this.bigintData = bigintData;
        this.doubleData = doubleData;
        this.varcharData = varcharData;
        this.booleanData = booleanData;
        this.dateData = dateData;
        this.timestampData = timestampData;
        this.jsonData = jsonData;
        this.hyperLogLogData = hyperLogLogData;
        this.bigintArrayData = bigintArrayData;
        this.dataReference = PrestoThriftBlock.theOnlyNonNull(integerData, bigintData, doubleData, varcharData, booleanData, dateData, timestampData, jsonData, hyperLogLogData, bigintArrayData);
    }

    @Nullable
    @ThriftField(value=1, requiredness=ThriftField.Requiredness.OPTIONAL)
    public PrestoThriftInteger getIntegerData() {
        return this.integerData;
    }

    @Nullable
    @ThriftField(value=2, requiredness=ThriftField.Requiredness.OPTIONAL)
    public PrestoThriftBigint getBigintData() {
        return this.bigintData;
    }

    @Nullable
    @ThriftField(value=3, requiredness=ThriftField.Requiredness.OPTIONAL)
    public PrestoThriftDouble getDoubleData() {
        return this.doubleData;
    }

    @Nullable
    @ThriftField(value=4, requiredness=ThriftField.Requiredness.OPTIONAL)
    public PrestoThriftVarchar getVarcharData() {
        return this.varcharData;
    }

    @Nullable
    @ThriftField(value=5, requiredness=ThriftField.Requiredness.OPTIONAL)
    public PrestoThriftBoolean getBooleanData() {
        return this.booleanData;
    }

    @Nullable
    @ThriftField(value=6, requiredness=ThriftField.Requiredness.OPTIONAL)
    public PrestoThriftDate getDateData() {
        return this.dateData;
    }

    @Nullable
    @ThriftField(value=7, requiredness=ThriftField.Requiredness.OPTIONAL)
    public PrestoThriftTimestamp getTimestampData() {
        return this.timestampData;
    }

    @Nullable
    @ThriftField(value=8, requiredness=ThriftField.Requiredness.OPTIONAL)
    public PrestoThriftJson getJsonData() {
        return this.jsonData;
    }

    @Nullable
    @ThriftField(value=9, requiredness=ThriftField.Requiredness.OPTIONAL)
    public PrestoThriftHyperLogLog getHyperLogLogData() {
        return this.hyperLogLogData;
    }

    @Nullable
    @ThriftField(value=10, requiredness=ThriftField.Requiredness.OPTIONAL)
    public PrestoThriftBigintArray getBigintArrayData() {
        return this.bigintArrayData;
    }

    public Block toBlock(Type desiredType) {
        return this.dataReference.toBlock(desiredType);
    }

    public int numberOfRecords() {
        return this.dataReference.numberOfRecords();
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        PrestoThriftBlock other = (PrestoThriftBlock)obj;
        return Objects.equals(this.dataReference, other.dataReference);
    }

    public int hashCode() {
        return Objects.hash(this.integerData, this.bigintData, this.doubleData, this.varcharData, this.booleanData, this.dateData, this.timestampData, this.jsonData, this.hyperLogLogData, this.bigintArrayData);
    }

    public String toString() {
        return MoreObjects.toStringHelper((Object)this).add("data", (Object)this.dataReference).toString();
    }

    public static PrestoThriftBlock integerData(PrestoThriftInteger integerData) {
        return new PrestoThriftBlock(integerData, null, null, null, null, null, null, null, null, null);
    }

    public static PrestoThriftBlock bigintData(PrestoThriftBigint bigintData) {
        return new PrestoThriftBlock(null, bigintData, null, null, null, null, null, null, null, null);
    }

    public static PrestoThriftBlock doubleData(PrestoThriftDouble doubleData) {
        return new PrestoThriftBlock(null, null, doubleData, null, null, null, null, null, null, null);
    }

    public static PrestoThriftBlock varcharData(PrestoThriftVarchar varcharData) {
        return new PrestoThriftBlock(null, null, null, varcharData, null, null, null, null, null, null);
    }

    public static PrestoThriftBlock booleanData(PrestoThriftBoolean booleanData) {
        return new PrestoThriftBlock(null, null, null, null, booleanData, null, null, null, null, null);
    }

    public static PrestoThriftBlock dateData(PrestoThriftDate dateData) {
        return new PrestoThriftBlock(null, null, null, null, null, dateData, null, null, null, null);
    }

    public static PrestoThriftBlock timestampData(PrestoThriftTimestamp timestampData) {
        return new PrestoThriftBlock(null, null, null, null, null, null, timestampData, null, null, null);
    }

    public static PrestoThriftBlock jsonData(PrestoThriftJson jsonData) {
        return new PrestoThriftBlock(null, null, null, null, null, null, null, jsonData, null, null);
    }

    public static PrestoThriftBlock hyperLogLogData(PrestoThriftHyperLogLog hyperLogLogData) {
        return new PrestoThriftBlock(null, null, null, null, null, null, null, null, hyperLogLogData, null);
    }

    public static PrestoThriftBlock bigintArrayData(PrestoThriftBigintArray bigintArrayData) {
        return new PrestoThriftBlock(null, null, null, null, null, null, null, null, null, bigintArrayData);
    }

    public static PrestoThriftBlock fromBlock(Block block, Type type) {
        switch (type.getTypeSignature().getBase()) {
            case "integer": {
                return PrestoThriftInteger.fromBlock(block);
            }
            case "bigint": {
                return PrestoThriftBigint.fromBlock(block);
            }
            case "double": {
                return PrestoThriftDouble.fromBlock(block);
            }
            case "varchar": {
                return PrestoThriftVarchar.fromBlock(block, type);
            }
            case "boolean": {
                return PrestoThriftBoolean.fromBlock(block);
            }
            case "date": {
                return PrestoThriftDate.fromBlock(block);
            }
            case "timestamp": {
                return PrestoThriftTimestamp.fromBlock(block);
            }
            case "json": {
                return PrestoThriftJson.fromBlock(block, type);
            }
            case "HyperLogLog": {
                return PrestoThriftHyperLogLog.fromBlock(block);
            }
            case "array": {
                Type elementType = (Type)type.getTypeParameters().stream().collect(MoreCollectors.onlyElement());
                if (BigintType.BIGINT.equals((Object)elementType)) {
                    return PrestoThriftBigintArray.fromBlock(block);
                }
                throw new IllegalArgumentException("Unsupported array block type: " + type);
            }
        }
        throw new IllegalArgumentException("Unsupported block type: " + type);
    }

    public static PrestoThriftBlock fromRecordSetColumn(RecordSet recordSet, int columnIndex, int totalRecords) {
        Type type = (Type)recordSet.getColumnTypes().get(columnIndex);
        switch (type.getTypeSignature().getBase()) {
            case "integer": {
                return PrestoThriftInteger.fromRecordSetColumn(recordSet, columnIndex, totalRecords);
            }
            case "bigint": {
                return PrestoThriftBigint.fromRecordSetColumn(recordSet, columnIndex, totalRecords);
            }
            case "date": {
                return PrestoThriftDate.fromRecordSetColumn(recordSet, columnIndex, totalRecords);
            }
            case "timestamp": {
                return PrestoThriftTimestamp.fromRecordSetColumn(recordSet, columnIndex, totalRecords);
            }
        }
        return PrestoThriftBlock.fromBlock(PrestoThriftBlock.convertColumnToBlock(recordSet, columnIndex, totalRecords), type);
    }

    private static Block convertColumnToBlock(RecordSet recordSet, int columnIndex, int positions) {
        Type type = (Type)recordSet.getColumnTypes().get(columnIndex);
        BlockBuilder output = type.createBlockBuilder(null, positions);
        Class javaType = type.getJavaType();
        RecordCursor cursor = recordSet.cursor();
        for (int position = 0; position < positions; ++position) {
            Preconditions.checkState((boolean)cursor.advanceNextPosition(), (Object)"cursor has less values than expected");
            if (cursor.isNull(columnIndex)) {
                output.appendNull();
                continue;
            }
            if (javaType == Boolean.TYPE) {
                type.writeBoolean(output, cursor.getBoolean(columnIndex));
                continue;
            }
            if (javaType == Long.TYPE) {
                type.writeLong(output, cursor.getLong(columnIndex));
                continue;
            }
            if (javaType == Double.TYPE) {
                type.writeDouble(output, cursor.getDouble(columnIndex));
                continue;
            }
            if (javaType == Slice.class) {
                Slice slice = cursor.getSlice(columnIndex);
                type.writeSlice(output, slice, 0, slice.length());
                continue;
            }
            type.writeObject(output, cursor.getObject(columnIndex));
        }
        Preconditions.checkState((!cursor.advanceNextPosition() ? 1 : 0) != 0, (Object)"cursor has more values than expected");
        return output.build();
    }

    private static PrestoThriftColumnData theOnlyNonNull(PrestoThriftColumnData ... columnsData) {
        PrestoThriftColumnData result = null;
        for (PrestoThriftColumnData data : columnsData) {
            if (data == null) continue;
            Preconditions.checkArgument((result == null ? 1 : 0) != 0, (Object)"more than one type is present");
            result = data;
        }
        Preconditions.checkArgument((result != null ? 1 : 0) != 0, (Object)"no types are present");
        return result;
    }
}

